local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local actor = require("narrative.actor")
local color = require("core.color")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, kraActor, athActor, cine_lights_380, candlesA, candlesB, candlesC, tableA, body, mistletoeleaves
local rug = GameObjects.trapDoorRug00RBCineOnly.Child
local chain00, chain01, chain02, chain03, cineEnterCamera_RetrieveBlades
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  InitializeVariables()
  HideCineLights()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 375 <= cineNum and cineNum < 380 then
    EnableDoor()
  else
    HideForcedCloseCamera_RetrieveBlades()
  end
end
function OnUpdate()
  if cineEnterCamera_RetrieveBlades ~= nil then
    cineEnterCamera_RetrieveBlades:Update()
  end
end
function InitializeVariables()
  CreateActors()
  SetSpawnFunctions()
  cine_lights_380 = GameObjects.Cine_Start_380
  GetChains()
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  athActor = actor.Actor.New("Athena")
end
function SetSpawnFunctions()
  athActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_RetrieveBlades", "Athena_Start", "CRT_Athena00", "BRA_Spawn", "Athena")
  end)
end
function BuildCineSequence()
  game.UI.LoadCheck("For200_c380_RetrieveBlades")
  HideTable()
  local doorObj = GameObjects.KratosHouseDoorA.Child
  doorObj.LuaObjectScript.Enable()
  local trapdoorObj = GameObjects.houseTrapDoor.Child
  local retrieveBladesSeq = ND.CreateCineSequence(thisLevel, thisObj, "retrieveBlades")
  local retrieveBlades_ActorTable = {
    {Actor = athActor, name = "athena"},
    {
      Obj = doorObj,
      Anim = "narProRetrieveBlades000CineScene",
      name = "door"
    },
    {
      Obj = trapdoorObj,
      Anim = "narProRetrieveBlades000CineScene",
      name = "trapdoor"
    },
    {
      Obj = rug,
      Anim = "narProRetrieveBlades000CineScene",
      name = "rug"
    },
    {
      Obj = chain00,
      Anim = "narProRetrieveBlades000CineScene",
      name = "chain0"
    },
    {
      Obj = chain01,
      Anim = "narProRetrieveBlades000CineScene1",
      name = "chain1"
    },
    {
      Obj = chain02,
      Anim = "narProRetrieveBlades000CineScene2",
      name = "chain2"
    },
    {
      Obj = chain03,
      Anim = "narProRetrieveBlades000CineScene3",
      name = "chain3"
    }
  }
  GameObjects.KratosHouseDoorA.Child.LuaObjectScript.EnableCinematicTrigger()
  game.World.DisablePlayerStateSoftSave()
  retrieveBladesSeq:SetPostSkipMusic("SND_MX_PRO_start_master", nil, nil, nil, "SND_MX_PRO_got_blades_fight_in")
  retrieveBladesSeq:MarkAbleToSkip()
  retrieveBladesSeq:RequestCineModeAndWait(kraActor, thisObj)
  retrieveBladesSeq:Do(StartCineEnter_RetrieveBlades)
  retrieveBladesSeq:Do(function()
    rug:Show()
  end)
  retrieveBladesSeq:SpawnActorAndWait(athActor)
  retrieveBladesSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_RetrieveBlades",
    ReferenceJoint = "RetrieveBlades_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    weapon_state = "bare_on_back",
    radius = ND.ArrivalRadius
  })
  retrieveBladesSeq:Do(function()
    athActor:GetCreature():Hide()
  end)
  retrieveBladesSeq:Do(PlayCineLights)
  retrieveBladesSeq:ActorSync(kraActor, {
    Slaves = retrieveBlades_ActorTable,
    Branch = "BRA_RetrieveBlades",
    ReferenceJoint = "RetrieveBlades_SyncJoint"
  })
  retrieveBladesSeq:Do(PlayCloth)
  retrieveBladesSeq:WaitUntilActorAnimPastFrame(kraActor, 1900)
  retrieveBladesSeq:Do(function()
    athActor:GetCreature():Show()
  end)
  retrieveBladesSeq:WaitUntilActorAnimPastFrame(kraActor, 4380)
  retrieveBladesSeq:Do(function()
    local for200_c380 = game.FindLevel("For200_c380_RetrieveBlades")
    for200_c380:CallScript("Helwalkers_Meet_Blades")
    player:MeterSetValue("Health", player:MeterGetMax("Health"))
  end)
  retrieveBladesSeq:WaitUntilActorAnimPastFrame(kraActor, 4400)
  retrieveBladesSeq:Do(ShowForcedCloseCamera_RetrieveBlades)
  retrieveBladesSeq:Do(HideChains)
  retrieveBladesSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  retrieveBladesSeq:StopPuppetingActor(kraActor)
  retrieveBladesSeq:StopPuppetingActor(athActor)
  retrieveBladesSeq:Do(HideCineLights)
  retrieveBladesSeq:DespawnActor(athActor)
  retrieveBladesSeq:Do(function()
    rug:Hide()
  end)
  retrieveBladesSeq:Do(function()
    doorObj.LuaObjectScript.Disable()
  end)
  retrieveBladesSeq:SetCompletedCineNumber(380)
  retrieveBladesSeq:Do(AwardMuspRecipeLate)
  retrieveBladesSeq:Do(function()
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("010_FirstBlades")
    end, 0.7)
  end)
  retrieveBladesSeq:Do(function()
    game.World.EnablePlayerStateSoftSave()
  end)
  retrieveBladesSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "17_Forest_020_GotBlades"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  retrieveBladesSeq:StartSequence()
end
function PlayCineLights()
  cine_lights_380:Show()
  cine_lights_380:JumpAnimToFrame(0)
  cine_lights_380:PlayAnimToEnd()
end
function HideCineLights()
  cine_lights_380:Hide()
end
function HideChains()
  chain00:Hide()
  chain01:Hide()
  chain02:Hide()
  chain03:Hide()
  local cloth = GameObjects.retrieveBladesCloth
  cloth:Hide()
end
function PlayCloth()
  local cloth = GameObjects.retrieveBladesCloth
  cloth:JumpAnimToFrame(0)
  cloth:PlayAnimToEnd()
end
function HideTable()
  candlesA = GameObjects.mothersCandles00A.Child
  candlesB = GameObjects.mothersCandles00B.Child
  candlesC = GameObjects.smallCandle00A.Child
  tableA = GameObjects.mothersTable00A.Child
  body = GameObjects.motherBody00A.Child
  mistletoeleaves = GameObjects.mistletoeLeaves00A.Child
  candlesA:Hide()
  candlesB:Hide()
  candlesC:Hide()
  tableA:Hide()
  body:Hide()
  mistletoeleaves:Hide()
end
function GetChains()
  chain00 = GameObjects.kratosChains00Top.Child
  chain01 = GameObjects.kratosChains01.Child
  chain02 = GameObjects.kratosChains02.Child
  chain03 = GameObjects.kratosChains03.Child
end
function DisableDoor()
  print("========= DISABLE DOOR FROM RETRIEVE BLADES ========")
  local kratosHouseDoor = GameObjects.KratosHouseDoorA.Child
  kratosHouseDoor.LuaObjectScript.Disable()
end
function EnableDoor()
  print("========= ENABLE DOOR FROM RETRIEVE BLADES ========")
  local kratosHouseDoor = GameObjects.KratosHouseDoorA.Child
  kratosHouseDoor.LuaObjectScript.Enable()
end
function AwardMuspRecipeLate()
  if game.Level.GetVariable("CAL_RealmUnlocked_Muspelheim") == true then
    game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_Muspelheim01")
    if game.GetNewGamePlus() then
      game.Wallets.AddRecipe("HERO", "Recipe_WeaponComponent_Blades_Muspelheim01_NGP")
    end
  end
end
function StartCineEnter_RetrieveBlades()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_RetrieveBlades = CCEC.CineEnterCamera.New("ENV_CineEnter_RetrieveBlades", 7)
  cineEnterCamera_RetrieveBlades:SetCallback(DestroyCineEnter_RetrieveBlades)
  cineEnterCamera_RetrieveBlades:Start()
end
function DestroyCineEnter_RetrieveBlades()
  cineEnterCamera_RetrieveBlades = nil
  game.SubObject.Sleep(thisObj)
end
function ShowForcedCloseCamera_RetrieveBlades()
  GameObjects.CamZone_RetrieveBlades_ForcedCamera:ShowCameraVolume()
end
function HideForcedCloseCamera_RetrieveBlades()
  GameObjects.CamZone_RetrieveBlades_ForcedCamera:HideCameraVolume()
end
