local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local actor = require("narrative.actor")
local ND = require("design.NarrativeDesignLibrary")
local CCEC = require("camera.camera_cineentercamera")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, forestLeadTheWay, forestShallNotPass, player, kratosActor, sonActor, cine_lights_100, candlesA, candlesB, candlesC, tableA, body, mistletoeleaves, houseTrapDoor, kratosHouseDoor, son, cineEnterCamera_TimeToGo
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnStart(level, obj)
  InitializeProps()
  if game.Level.GetVariable("CompletedCineNumber") >= 100 and game.Level.GetVariable("CompletedCineNumber") < 375 then
    DisableDoor()
  end
end
function OnUpdate()
  if cineEnterCamera_TimeToGo ~= nil then
    cineEnterCamera_TimeToGo:Update()
  end
end
function InitializeProps()
  cine_lights_100 = GameObjects.Cine_Start_100
  cine_lights_100:Hide()
  kratosHouseDoor = GameObjects.KratosHouseDoorA.Child
  houseTrapDoor = GameObjects.houseTrapDoor.Child
  houseTrapDoor:StartAnim("narForTimeToGo010Cine")
  houseTrapDoor:JumpAnimToFrame(0)
  houseTrapDoor:PauseAnim()
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function IsSonAvailableForCines()
  return son:IsAvailableInLevel() and son:IsAvailableForBanter() and son:IsAvailableForSync()
end
function SonWaitUnderTrapdoor()
  local sonUndergroundSeq = LD.CreateCineSequence(thisLevel, thisObj, "putSonUnderTrapdoor")
  sonUndergroundSeq:ActorSync(sonActor, {
    Branch = "BRA_TimeToGoStartIdle",
    ReferenceJoint = "TimeToGo_SyncJoint"
  })
  sonUndergroundSeq:StartSequence()
end
function PlayTimeToGoCine()
  game.UI.LoadCheck("For200_c100_TimeToGo")
  GameObjects.SCRIPT_ArenaBlocker:PlayAnimToEnd()
  CreateActors()
  HideTable()
  SonWaitUnderTrapdoor()
  if player:HasMarker("ReadyForTimeToGo") then
    player:RemoveMarker("ReadyForTimeToGo")
  end
  local cloth = GameObjects.retrieveBladesCloth
  cloth:JumpAnimToFrame(0)
  cloth:PauseAnim()
  local timeToGoSeq = LD.CreateCineSequence(thisLevel, thisObj, "timeToGo")
  local table = {
    {
      Actor = sonActor,
      Branch = "BRA_TimeToGo"
    },
    {
      Obj = houseTrapDoor,
      Anim = "narForTimeToGo010Cine"
    },
    {
      Obj = kratosHouseDoor,
      Anim = "narForTimeToGo010Cine"
    }
  }
  timeToGoSeq:SetPostSkipMusic("SND_MX_PRO_start_master", nil, nil, nil, "SND_MX_PRO_go_to_chasm")
  timeToGoSeq:MarkAbleToSkip()
  timeToGoSeq:RequestCineModeAndWait(kratosActor, thisObj)
  timeToGoSeq:Do(StartCineEnter_TimeToGo)
  timeToGoSeq:Do(function()
    timer.StartLevelTimer(10, CameraEnableCloserCameraHackZone)
  end)
  timeToGoSeq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_TimeToGo",
    ReferenceJoint = "TimeToGo_SyncJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    radius = 0.15,
    should_strafe = true,
    weapon_state = "bare"
  })
  timeToGoSeq:Do(StoreLeadTheWayVars)
  timeToGoSeq:Do(PlayCineLights)
  timeToGoSeq:Do(CallRug)
  timeToGoSeq:Do(function()
    son:RemoveAvailabilityRequest("SonUnavailable")
  end)
  timeToGoSeq:WaitForFunctionTrue(IsSonAvailableForCines)
  timeToGoSeq:ActorSync(kratosActor, {
    Slaves = table,
    Branch = "BRA_TimeToGo",
    ReferenceJoint = "TimeToGo_SyncJoint"
  })
  timeToGoSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
  timeToGoSeq:StopPuppetingActor(kratosActor)
  timeToGoSeq:StopPuppetingActor(sonActor)
  timeToGoSeq:Do(ReturnDoorToDefault)
  timeToGoSeq:Do(HidePropsAndLights)
  timeToGoSeq:SetCompletedCineNumber(100)
  timeToGoSeq:WaitForActorInZone(kratosActor, thisObj)
  timeToGoSeq:Do(HideRug)
  timeToGoSeq:Do(DisableLeadTheWay)
  timeToGoSeq:Do(DisableDoor)
  timeToGoSeq:Do(SonContextAction)
  timeToGoSeq:Do(function()
    LD.EnableCombatBanter()
  end)
  timeToGoSeq:Do(CompletePrologueQuest)
  timeToGoSeq:Do(StartRiverPassParent)
  timeToGoSeq:Do(function()
    LD.EnableContextBehaviorBanter()
  end)
  timeToGoSeq:Do(function()
    if timeToGoSeq.skipping then
      game.Audio.PlayBanter("455_MountainGoal")
    end
  end)
  timeToGoSeq:Do(function()
    local bookmarks = require("design.Bookmarks")
    local tableEntry = bookmarks["BOOKMARK_" .. "01_Forest_060_BaldurDone"]
    game.World.StoreCheckpointAndBookmark(tableEntry)
  end)
  timeToGoSeq:StartSequence()
end
function CallRug()
  _G.HideTrapDoorRug()
  local For200c100 = game.FindLevel("For200_c100_TimeToGo")
  if For200c100 ~= nil then
    local cine_BaldurRug_Obj = For200c100:GetGameObject("BaldurRug_TTG")
    cine_BaldurRug_Obj:CallScript("PlayBaldurRug")
  end
end
function HideRug()
  local For200c100 = game.FindLevel("For200_c100_TimeToGo")
  if For200c100 ~= nil then
    local cine_BaldurRug_Obj = For200c100:GetGameObject("BaldurRug_TTG")
    cine_BaldurRug_Obj:CallScript("HideBaldurRug")
  end
end
function HidePropsAndLights()
  cine_lights_100:Hide()
end
function ReturnDoorToDefault()
  kratosHouseDoor.LuaObjectScript.IncludeSon()
  kratosHouseDoor.LuaObjectScript.Enable()
end
function StoreLeadTheWayVars()
  local for000_sky = game.FindLevel("For000_Sky")
  forestLeadTheWay = for000_sky:GetGameObject("ForestLeadTheWay").Child
  forestShallNotPass = for000_sky:GetGameObject("ForestYouShallNotPass").Child
end
function DisableLeadTheWay()
  forestLeadTheWay:CallScript("Disable")
  forestShallNotPass:CallScript("Disable")
end
function SonContextAction()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
  local for350 = game.FindLevel("For350_ExitTunnel")
  if for350 ~= nil then
    for350:CallScript("EnableSonPathing")
  end
  GameObjects.CA_Idle_WaitNearFront.LuaObjectScript.Disable()
end
function CompletePrologueQuest()
  game.QuestManager.ProposeQuestState("Quest_Forest_Objective1000", "Complete")
end
function StartRiverPassParent()
  LD.ActivateQuest("Quest_RiverPass_Parent01")
  local baldurBestiaryEntry = game.Wallets.GetResourceValue("HERO", "Bestiary_Unlock_Baldur")
  if baldurBestiaryEntry <= 0 then
    LD.UnlockBestiaryEntry("Bestiary_Unlock_Stranger")
  end
end
function PlayCineLights()
  cine_lights_100:Show()
  cine_lights_100:JumpAnimToFrame(0)
  cine_lights_100:PlayAnimToEnd()
end
function HideTable()
  candlesA = GameObjects.mothersCandles00A.Child
  candlesB = GameObjects.mothersCandles00B.Child
  candlesC = GameObjects.smallCandle00A.Child
  tableA = GameObjects.mothersTable00A.Child
  body = GameObjects.motherBody00A.Child
  mistletoeleaves = GameObjects.mistletoeLeaves00A.Child
  candlesA:Hide()
  candlesB:Hide()
  candlesC:Hide()
  tableA:Hide()
  body:Hide()
  mistletoeleaves:Hide()
end
function DisableDoor()
  local kratosHouseDoor = GameObjects.KratosHouseDoorA.Child
  kratosHouseDoor.LuaObjectScript.Disable()
end
function StartCineEnter_TimeToGo()
  game.SubObject.Wake(thisObj)
  cineEnterCamera_TimeToGo = CCEC.CineEnterCamera.New("ENV_CineEnter_TimeToGo", 7)
  cineEnterCamera_TimeToGo:SetCallback(DestroyCineEnter_TimeToGo)
  cineEnterCamera_TimeToGo:Start()
end
function DestroyCineEnter_TimeToGo()
  cineEnterCamera_TimeToGo = nil
  game.SubObject.Sleep(thisObj)
end
function CameraEnableCloserCameraHackZone()
  GameObjects.CamZone_FrontDoor_TimeToGo_Exit:ShowCameraVolume()
end
function CameraDisableCloserCameraHackZone()
  GameObjects.CamZone_FrontDoor_TimeToGo_Exit:HideCameraVolume()
end
