local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local thisObj, thisLevel
local chiselDoorPlayed = false
local kraActor, sonActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  SetupActors()
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {chiselDoorPlayed = chiselDoorPlayed}
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  chiselDoorPlayed = savedInfo.chiselDoorPlayed
end
function SetupActors()
  kraActor = actor.Actor.New("OPENING: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("OPENING: Son Actor", game.AI.FindSon)
end
function POI_ChiselDoors()
  if game.Wallets.GetResourceValue("HERO", "ChiselUnlock") <= 0 and chiselDoorPlayed == false then
    chiselDoorPlayed = true
    local chiselDoorsSeq = ND.CreateCineSequence(thisLevel, thisObj, "Chisel Doors")
    local chiselDoors_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_ChiselDoors"
      }
    }
    GameObjects.ChiselDoor_Hero_02.Child.LuaObjectScript.EnableCinematicTrigger()
    chiselDoorsSeq:RequestCineModeAndWait(kraActor, thisObj)
    chiselDoorsSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_ChiselDoors",
      ReferenceJoint = "POI_ChiselDoors_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = ND.InteractStopDistance,
      weapon_state = "bare_on_back"
    })
    chiselDoorsSeq:ActorSync(kraActor, {
      Slaves = chiselDoors_ActorTable,
      Branch = "BRA_ChiselDoors",
      ReferenceJoint = "POI_ChiselDoors_SynchJoint"
    })
    chiselDoorsSeq:Do(ForestChiselDoorBanter)
    chiselDoorsSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    chiselDoorsSeq:StopPuppetingActor(kraActor)
    chiselDoorsSeq:StopPuppetingActor(sonActor)
    chiselDoorsSeq:StartSequence()
  end
end
function ForestChiselDoorBanter()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("320_ForestChiselDoors")
  end, 3)
end
function RevisitBanter()
  game.Audio.PlayBanter("020_ForestChiselDoors_Revisit")
end
