local LD = require("design.LevelDesignLibrary")
uiCalls = require("ui.uicalls")
local thisLevel, player, son, for260, ChiselElevator, ElevatorManager
function OnScriptLoaded(level)
  thisLevel = level
  ChiselElevator = level:GetGameObject("ChiselDungeon_Elevator")
  ElevatorManager = ChiselElevator:FindSingleGOByName("ElevatorManager")
  SoundInit()
end
function OnFirstStart(level)
end
function OnStart(level)
  SoundOnStart()
end
function LoadCheck_For250()
  game.UI.LoadCheck("For250_ChiselSite")
end
function LoadCheck_For260()
  game.UI.LoadCheck("For260_ChiselDungeon")
end
function JumpElevator()
  ElevatorManager.LuaObjectScript.JumpToBottomFloor()
end
function JumpElevatorToTop()
  ElevatorManager.LuaObjectScript.JumpToTopFloor()
end
function For260_LTW_Enable()
  local for260 = game.FindLevel("For260_ChiselDungeon")
  if for260 ~= nil then
    for260:CallScript("LTW_Lobby_Enable")
    for260:CallScript("CA_Lobby_Enable")
  end
end
function For260_LTW_Disable()
  local for260 = game.FindLevel("For260_ChiselDungeon")
  if for260 ~= nil then
    for260:CallScript("LTW_Lobby_Disable")
    for260:CallScript("CA_Lobby_Disable")
  end
end
function LTW_On()
  GameObjects.LeadTheWay_255.LuaObjectScript.Enable()
end
function LTW_Off()
  GameObjects.LeadTheWay_255.LuaObjectScript.Disable()
end
function AreaAnnounce()
  uiCalls.UI_Event_DiscoverLocation("Forest Chisel Dungeon")
  ChiselLabor()
end
function ChiselLabor()
  local questState = game.QuestManager.GetQuestState("Quest_Labor_ChiselDungeon_Open_For")
  if questState ~= "Complete" then
    LD.ActivateQuest("Quest_Labor_ChiselDungeons_Parent")
    LD.CompleteQuest("Quest_Labor_ChiselDungeon_Open_For")
    game.QuestManager.IncrementQuestProgress("Quest_Labor_ChiselDungeon_Open", 1)
  end
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
local elevatorManagerObject
local elevatorSoundOverride = {
  SoundEmitter = nil,
  OnStart = "",
  AnimFrameOnStart = 0,
  OnReturnToStart = "",
  AnimFrameOnReturnToStart = 0,
  OnForward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnForward = 0,
  OnBackward = "SND_MECH_Elevator_Chisel_Room_Lift_LP",
  AnimFrameOnBackward = 0,
  OnStartFromEnd = "",
  AnimFrameOnStartFromEnd = 0,
  OnEnd = "",
  AnimFrameOnEnd = 1
}
function SoundInit()
  elevatorManagerObject = thisLevel:GetGameObject("ElevatorManager")
  elevatorSoundOverride.SoundEmitter = elevatorManagerObject.Parent:FindSingleSoundEmitterByName("SNDChiselElevator")
end
function SoundOnStart()
  elevatorManagerObject.LuaObjectScript.SoundSetup(elevatorSoundOverride)
end
