local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local thisLevel
function OnScriptLoaded(level)
  thisLevel = level
end
function OnStart(level)
  thisLevel = level
  local houseLevel = game.FindLevel("For200_House")
  houseLevel:CallScript("CallScriptVisibility", "SCRIPTED_House_Roof_Hires_Broken_Section", false)
  houseLevel:CallScript("CallScriptVisibility", "SCRIPTED_baldur_roof_bugsplat_clean", false)
end
function CallScriptVisibility(level, objectName, isVisible)
  if isVisible then
    DL.ShowLevelObject(thisLevel, objectName)
  else
    DL.HideLevelObject(thisLevel, objectName)
  end
end
function CallScriptWarp(level, propName, warpPoint)
  local myProp = thisLevel:FindSingleGameObject(propName)
  DL.WarpGameObject(myProp, thisLevel, warpPoint)
  DL.ShowLevelObject(thisLevel, propName)
end
function CallScriptRegisterProp(level, propName, warpName)
end
function SetPropVisibility()
  if game.Level.GetVariable("CompletedCineNumber") >= 72 and LD.GetEntityVariable("FOR_BaldurBossDone") == false then
    DL.HideLevelObject(thisLevel, "BREAK_TreePlow_Stump")
    DL.HideLevelObject(thisLevel, "BREAK_TreePlow_Ripout")
    DL.HideLevelObject(thisLevel, "SCRIPTED_Landmark_Fallen")
    DL.HideLevelObject(thisLevel, "SCRIPTED_Landmark_Prop")
  end
end
function CallScriptAnim(level, objectName, animType)
  if animType == "play" then
    DL.PlayObjectAnimationChild(thisLevel, objectName)
  elseif animType == "reset" then
    DL.ResetObjectAnimationChild(thisLevel, objectName)
  elseif animType == "finish" then
    DL.FinishObjectAnimationChild(thisLevel, objectName)
  end
end
function CallScriptAnimFrames(level, objectName, startFrame, endFrame)
  DL.PlayObjectAnimationChildFrameRange(level, objectName, startFrame, endFrame)
end
