local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local CSL = require("camera.shakelibrary")
local checkpoint = require("level.checkpoint")
thisLevel = nil
player = nil
son = nil
firstExitDone = nil
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  SoundInit()
end
function OnStartGameFromThisLevel(level)
  LD.SetEntityVariable("FOR_BaldurBossDone", true)
end
function OnStart()
  if game.Level.GetVariable("CompletedCineNumber") >= 100 and game.Level.GetVariable("CompletedCineNumber") <= 180 then
    GameObjects.DisableCAWhenKratosCatchUp:ShowEntityVolume()
  else
    GameObjects.DisableCAWhenKratosCatchUp:HideEntityVolume()
  end
  GameObjects.EntZn_RemoveClimbTutorial:HideEntityVolume()
end
function OnUpdate(level)
  UpdateCamera()
end
function OnSaveCheckpoint(level)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  savedInfo.firstExitDone = firstExitDone
  return savedInfo
end
function OnRestoreCheckpoint(level, savedInfo)
  if savedInfo ~= nil then
    firstExitDone = savedInfo.firstExitDone
  end
end
function ClimbTutorial()
  TUT.ClimbControls()
end
function RemoveClimbTutorial()
  timers.StartLevelTimer(1, function()
    uiCalls.UI_Event_TurnOffDesignerMessage()
    GameObjects.EntZn_RemoveClimbTutorial:HideEntityVolume()
  end)
end
function Show_WP_Hint()
  TUT.For350_PressWall_Tutorial()
end
function Hide_WP_Hint()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function Hide_WP_HintZone()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  GameObjects.WallPressTutorial:HideEntityVolume()
end
function Show_Jump_Hint()
  TUT.JumpGapsClimb_Tutorial()
end
function Hide_Jump_Hint()
  uiCalls.UI_Event_TurnOffTutorialMessage()
end
function Hide_Jump_HintZone()
  GameObjects.GapTutorial:HideEntityVolume()
end
function StartTreeBreak()
  GameObjects.for350_exittunnal_treefall.Child:PlayAnimToFrame(59)
end
function FinishTreeBreak()
  GameObjects.for350_exittunnal_treefall.Child:PlayAnimToEnd()
  PlayTremorSound()
  TreeBreakSound()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("465_NeverAlone", RemoveBtrSpeedControll00)
  end, 2.5)
  PlayFourthTremor()
end
function RemoveBtrSpeedControll00()
  GameObjects.EntZn_BtrSpeedControl00:HideEntityVolume()
end
function CrowFly()
end
function DisableClimb()
  GameObjects.TraversePath_Part1:HideTraversePath()
end
function EnableSonPathing()
  GameObjects.CA_SonBeforeChasm.LuaObjectScript.Enable()
  GameObjects.LTW_AfterWallPress.LuaObjectScript.Enable()
  GameObjects.LTW_Start.LuaObjectScript.Enable()
  GameObjects.CA_ClimbOut.LuaObjectScript.Enable()
end
function DisableCA_SonBeforeChasm()
  GameObjects.CA_SonBeforeChasm.LuaObjectScript.Disable()
end
function SyncExitClimbSide()
  if not firstExitDone then
    GameObjects.CA_SyncExit_ClimbSide.LuaObjectScript.Enable()
    firstExitDone = true
  else
    GameObjects.ca_syncexithelper.LuaObjectScript.Enable()
  end
end
local SNDTreefall
function SoundInit()
  SNDTreefall = GameObjects.SNDGrpTreeFall:FindSingleSoundEmitterByName("SNDTreefall")
end
function TreeBreakSound()
  LD.PlaySound(SNDTreefall, "SND_BRK_Wood_Tree_Collapse_01_For350")
  LD.PlaySoundAfterDelay(SNDTreefall, "SND_BRK_Wood_Tree_Collapse_02_For350", 1)
end
local CCOS = require("camera.camera_oneshot")
local bFiredRecenter = false
local camOneShot_WallPressWestExit, camOneShot_WallPressWestEnter
local bEnteredFromWest = false
local bEnterDirectionIsSet = false
function DestroyOneShot_WallPressWestExit()
  if camOneShot_WallPressWestExit ~= nil then
    camOneShot_WallPressWestExit = nil
  end
end
function CheckForWallPressWestExit()
  if bFiredRecenter == true then
    return
  end
  if player:HasMarker("Wallpress") and player:HasMarker("Exit") then
    bFiredRecenter = true
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 1.6,
      LockRecenter = 0.46,
      RotationSpace = 1,
      YawRange = -1,
      TriggerLeft = 0,
      ReturnLeft = -155,
      ReturnRight = -155,
      TriggerRight = -0,
      PitchRange = -1,
      TriggerUp = 0,
      ReturnUp = -2,
      ReturnDown = -2,
      TriggerDown = 0
    })
    timers.StartLevelTimer(1.6, function()
      bFiredRecenter = false
    end)
  end
end
function DestroyOneShot_WallPressWestEnter()
  if camOneShot_WallPressWestEnter ~= nil then
    camOneShot_WallPressWestEnter = nil
  end
end
function CheckForWallPressEnterDirection()
  local playerPos = player:GetWorldPosition()
  if bEnterDirectionIsSet == false and player:HasMarker("Wallpress") and player:HasMarker("Enter") then
    if game.World.IsInsideCameraZone(playerPos, "CamFrontPress_WestSide") == true then
      bEnteredFromWest = true
    else
      bEnteredFromWest = false
    end
    bEnterDirectionIsSet = true
  end
end
function CheckForWallPressExit()
  if player:HasMarker("Wallpress") and player:HasMarker("Exit") then
    bEnterDirectionIsSet = false
  end
end
function UpdateCamera()
  CheckForWallPressEnterDirection()
  CheckForWallPressExit()
  local playerPos = player:GetWorldPosition()
  if game.World.IsInsideCameraZone(playerPos, "CamFrontPress_Override") == true then
    game.Camera.SubmitCameraByName("PLYR_For350_WallpressTutorial")
  end
  if game.World.IsInsideCameraZone(playerPos, "CamFrontPress_WestSide") == true then
    CheckForWallPressWestExit()
    if bEnteredFromWest ~= true and player:HasMarker("WallPress") and player:HasMarker("Left") or player:HasMarker("WallPress") == false then
      game.Camera.SubmitCameraByName("PLYR_Nav_Wide_22mm_RightJustified")
    else
      game.Camera.SubmitCameraByName("PLYR_For350_WallpressTutorial")
    end
  end
end
function PlayFirstTremor()
  CSL.PlayDefaultShake("CrumbleLower", 2.2, 0.1, 1.3)
  PlayTremorSound()
end
function PlaySecondTremor()
  CSL.PlayDefaultShake("CrumbleLow", 2.5, 0.3, 1.23)
  PlayTremorSound()
end
function PlayThirdTremor()
  CSL.PlayDefaultShake("CrumbleGeneric", 2.8, 0, 1.6)
  PlayTremorSound()
end
function PlayFourthTremor()
  CSL.PlayDefaultShake("CrumbleGeneric", 1.2, 0, 0.1)
  timers.StartLevelTimer(1.2, function()
    CSL.PlayDefaultShake("ShakeRumbleLarge")
  end)
  timers.StartLevelTimer(2.2, function()
    CSL.PlayDefaultShake("CrumbleGeneric", 0.8, 0, 0.5)
  end)
  timers.StartLevelTimer(3.69, function()
    CSL.PlayDefaultShake("ShakeRumbleSmall")
  end)
  timers.StartLevelTimer(4, function()
    CSL.PlayDefaultShake("CrumbleGeneric", 1.2, 0, 1.3)
  end)
  PlayTremorSound()
end
function PlayFifthTremor()
  CSL.PlayDefaultShake("CrumbleLower", 1.6, 0.6, 0.8)
  PlayTremorSound()
end
function PlaySixthTremor()
  CSL.PlayDefaultShake("CrumbleLower", 2.5, 0.6, 0.8)
  PlayTremorSound()
end
function PlayTremorSound()
  player:CallScript("PlaySoundOnKratos", "SND_AMB_BED_For350_Earthquake")
end
