local LD = require("design.LevelDesignLibrary")
local thisLevel
function OnScriptLoaded(level)
  thisLevel = level
end
function OnStartGameFromThisLevel(level)
  local seq = LD.CreateCineSequence(thisLevel, thisLevel, "turnOnLTW")
  seq:WaitForFunctionTrue(DoesSkyExist)
  seq:Do(EnableLTW)
  seq:StartSequence()
end
function OnStart()
  local for200 = game.FindLevel("For200_House")
  if for200 ~= nil then
    for200:CallScript("CallScriptVisibility", "For400_Cheap", false)
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 100 then
    GameObjects.InteractZone_MissedTracks.LuaObjectScript.Disable()
  end
end
function DoesSkyExist()
  return game.FindLevel("For000_Sky")
end
function EnableLTW()
  local for000 = game.FindLevel("For000_Sky")
  for000:GetGameObject("ForestLeadTheWay").Child:CallScript("Enable")
  for000:GetGameObject("ForestYouShallNotPass").Child:CallScript("Enable")
end
function ResourcesTutorialHint()
  local showHint = LD.GetEntityVariable("TUT_ShowResourceTutorialHint")
  if showHint == true then
    local TUT = require("game.GlobalTutorials")
    TUT.CollectResources_Tutorial()
    LD.SetEntityVariable("TUT_ShowResourceTutorialHint", false)
  end
end
function OnEvaluateLoadGroup_Cinematic()
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if cineNumber < 65 then
    return "For200_c020_MothersKnife"
  elseif 400 <= cineNumber then
    return "For200_c620_Epilogue"
  end
end
