local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local uiCalls = require("ui.uicalls")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, sonActor, kraActor
local btrMissedTracks = "060_MissedTracks"
local boolMissedTracks = false
local cineEnterMissedTracksCam
function OnScriptLoaded(level, obj)
end
function OnStart(level, obj)
  thisObj = obj
  thisLevel = level
  CreateActors()
  BuildSequences()
  GameObjects.EntZn_SpeedControlZone:HideEntityVolume()
  GameObjects.EntZn_SpeedControlZone2:HideEntityVolume()
end
function OnUpdate(level, obj)
  if cineEnterMissedTracksCam ~= nil then
    cineEnterMissedTracksCam:Update()
  end
end
function CreateActors()
  kraActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {playedSetupBool_MissedTracks = boolMissedTracks}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  boolMissedTracks = savedInfo.playedSetupBool_MissedTracks
end
function BuildSequences()
  BuildTracksSeq("Missed Tracks POI", "BRA_MissedTracksEnter", "MissedTracks_SynchJoint", "POIZone_MissedTracks", btrMissedTracks, boolMissedTracks, kraActor)
end
function BuildTracksSeq(poiTitle, seqBranch, seqSynchJoint, entZoneGO, banterString, boolBanterPlayed, triggeringActor)
  if boolBanterPlayed then
    return
  end
  local seq = ND.CreateCineSequence(thisLevel, thisObj, poiTitle)
  seq:WaitForActorInZone(triggeringActor, entZoneGO)
  seq:Do(function()
    boolBanterPlayed = true
  end)
  seq:ActorForceApproachAndWait(sonActor, {
    Branch = seqBranch,
    ReferenceJoint = seqSynchJoint,
    stop = false,
    radius = ND.RunArrivalRadius,
    foot = game.Creature.Foot.kRight,
    speed = ND.SonRunSpeed
  })
  seq:Do(function()
    game.Audio.PlayBanter(banterString)
  end)
  seq:ActorSync(sonActor, {Branch = seqBranch, ReferenceJoint = seqSynchJoint})
  seq:WaitForActorPuppeteerComplete(sonActor)
  seq:StopPuppetingActor(sonActor)
  seq:StartSequence()
end
function MissedTracksSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    local missedTrackSeq = LD.CreateCineSequence(thisLevel, thisObj, "Troll Aftermath B Sequence")
    local missedTrack_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_MissedTracks"
      }
    }
    missedTrackSeq:Do(CameraStartMissedTracksEnter)
    missedTrackSeq:RequestCineModeAndWait(kraActor, thisObj)
    missedTrackSeq:ActorForceApproachAndWait(kraActor, {
      Branch = "BRA_MissedTracks",
      ReferenceJoint = "MissedTracks_SynchJoint",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = 0.15,
      strafe_distance = 1,
      weapon_state = "bare"
    })
    missedTrackSeq:ActorSync(kraActor, {
      Slaves = missedTrack_ActorTable,
      Branch = "BRA_MissedTracks",
      ReferenceJoint = "MissedTracks_SynchJoint"
    })
    missedTrackSeq:WaitForActorPlayingMove(sonActor, "MOV_MissedTracksScene")
    missedTrackSeq:WaitForActorMoveComplete(sonActor)
    missedTrackSeq:StopPuppetingActor(sonActor)
    missedTrackSeq:Do(function()
      GameObjects.CA_syncexit_MissedTracks.LuaObjectScript.Enable()
    end)
    missedTrackSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    missedTrackSeq:WaitForActorMoveComplete(kraActor)
    missedTrackSeq:StopPuppetingActor(kraActor)
    missedTrackSeq:StartSequence()
  end
end
function FirstTracksBanter()
  if game.Level.GetVariable("CompletedCineNumber") >= 15 and game.Level.GetVariable("CompletedCineNumber") < 25 then
    GameObjects.BtrZone_FirstTracks:Hide()
  end
end
function SonGoTo_2ndDeerTrack()
  print("removed")
end
function POI_SecondTracks()
  if game.Level.GetVariable("CompletedCineNumber") >= 15 and game.Level.GetVariable("CompletedCineNumber") < 25 then
    local secondTrackSeq = LD.CreateCineSequence(thisLevel, thisObj, "New Second Tracks Sequence")
    secondTrackSeq:RequestCineModeAndWait(sonActor, thisObj)
    secondTrackSeq:Do(function()
      GameObjects.EntZn_SpeedControlZone2:ShowEntityVolume()
    end)
    secondTrackSeq:Do(function()
      game.Player.FindPlayer():SetDecelerationOverride(1.2)
    end)
    secondTrackSeq:Do(function()
      game.Player.FindPlayer():SetAccelerationOverride(0.9)
    end)
    secondTrackSeq:ActorForceApproachAndWait(sonActor, {
      Branch = "BRA_poiForSecondTracks",
      ReferenceJoint = "SecondTracks_SynchJoint",
      speed = ND.SonJogSpeed,
      stop = false,
      foot = game.Creature.Foot.kRight,
      radius = ND.SonRunArrivalRadius
    })
    secondTrackSeq:ActorSync(sonActor, {
      Branch = "BRA_poiForSecondTracks",
      ReferenceJoint = "SecondTracks_SynchJoint"
    })
    secondTrackSeq:WaitForAndCompleteCineMode(sonActor, thisObj)
    secondTrackSeq:WaitForActorMoveComplete(sonActor)
    secondTrackSeq:StopPuppetingActor(sonActor)
    secondTrackSeq:Do(function()
      LD.CallFunctionAfterDelay(function()
        game.Player.FindPlayer():ClearAccelerationOverride()
      end, 2.5)
    end)
    secondTrackSeq:Do(function()
      GameObjects.EntZn_SpeedControlZone2:HideEntityVolume()
    end)
    secondTrackSeq:Do(function()
      game.Player.FindPlayer():ClearDecelerationOverride()
    end)
    secondTrackSeq:StartSequence()
  end
end
function DisableSecondTracks()
  GameObjects.ContextAction_Son_InvestigateGround2.LuaObjectScript.Disable()
end
function NewTracksSeq()
  local firstTrackSeq = LD.CreateCineSequence(thisLevel, thisObj, "New First Tracks Sequence")
  firstTrackSeq:RequestCineModeAndWait(sonActor, thisObj)
  uiCalls.UI_Event_TurnOffDesignerMessage()
  firstTrackSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_poiForFirstTracks",
    ReferenceJoint = "FirstTracks_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.SonRunArrivalRadius
  })
  firstTrackSeq:ActorSync(sonActor, {
    Branch = "BRA_poiForFirstTracks",
    ReferenceJoint = "FirstTracks_SynchJoint"
  })
  firstTrackSeq:Do(function()
    GameObjects.EntZn_SpeedControlZone:ShowEntityVolume()
  end)
  firstTrackSeq:WaitSeconds(0.5)
  firstTrackSeq:Do(OverideCheck)
  firstTrackSeq:WaitForAndCompleteCineMode(sonActor, thisObj)
  firstTrackSeq:WaitForActorMoveComplete(sonActor)
  firstTrackSeq:StopPuppetingActor(sonActor)
  firstTrackSeq:Do(function()
    game.Player.FindPlayer():ClearDecelerationOverride()
  end)
  firstTrackSeq:Do(function()
    GameObjects.EntZn_AllowDecelOverride:HideEntityVolume()
  end)
  firstTrackSeq:Do(function()
    LD.CallFunctionAfterDelay(function()
      game.Player.FindPlayer():ClearAccelerationOverride()
    end, 3)
  end)
  firstTrackSeq:Do(function()
    GameObjects.EntZn_SpeedControlZone:HideEntityVolume()
  end)
  firstTrackSeq:Do(function()
    game.FindLevel("For000_Sky"):CallScript("Enable_SlowDown")
  end)
  firstTrackSeq:Do(function()
    LD.CallFunctionAfterDelay(function()
      TUT.BasicCamera_Tutorial()
    end, 1.6)
  end)
  firstTrackSeq:StartSequence()
end
function OverideCheck()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(0.75)
end
function CameraStartMissedTracksEnter()
  game.SubObject.Wake(thisObj)
  cineEnterMissedTracksCam = CCEC.CineEnterCamera.New("ENV_CineEnter_poiForMissedTracks020Scene", 6)
  cineEnterMissedTracksCam:SetCallback(CameraDestroyMissedTracksEnter)
  cineEnterMissedTracksCam:Start()
end
function CameraDestroyMissedTracksEnter()
  cineEnterMissedTracksCam = nil
  game.SubObject.Sleep(thisObj)
end
