local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local timers = require("level.timer")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
thisLevel = nil
player = nil
son = nil
local pad, buttonMonitor_L2Down, buttonMonitor_L2Up, BridgeAnimMonitor, boardsBroken, inputMask
local L2Pressed = false
local AxeTutorialPassed, kratosJumpDone, axethrownCheck, bListenForAimDuringRecenter
local axeInFlightDone = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  pad = player.Pad
  SoundInIt()
  bListenForAimDuringRecenter = false
end
function OnStartGameFromThisLevel()
  local seq = LD.CreateCineSequence(thisLevel, thisLevel, "turnOnLTW")
  seq:WaitForFunctionTrue(DoesSkyExist)
  seq:Do(EnableLTW)
  seq:StartSequence()
end
function OnFirstStart(level)
  GameObjects.TraverseLink_Jump02:HideTraverseLink()
  GameObjects.TraverseLink_Jump00:HideTraverseLink()
end
function OnStart(level)
  if not AxeTutorialPassed then
    buttonMonitor_L2Down = monitors.CreateL2ButtonMonitor()
    buttonMonitor_L2Down:OnButtonDown(StartAiming)
    buttonMonitor_L2Down:Stop()
    buttonMonitor_L2Up = monitors.CreateL2ButtonMonitor()
    buttonMonitor_L2Up:OnButtonUp(AimDone)
    buttonMonitor_L2Up:Stop()
  else
    GameObjects.TraverseLink_Jump02:ShowTraverseLink()
  end
  GameObjects.entityZone_AxeTut:HideEntityVolume()
  GameObjects.Col_StopTutBacktrack:HideCollision()
  GameObjects.Sheet_KratosBridgeTut:HideCollision()
  StopJumpTutorialMsg()
end
function OnUpdate(level)
  if kratosJumpDone == nil and game.World.IsInsideCameraZone(player.WorldPosition, "CamZone_AxeTutorial") then
    if bListenForAimDuringRecenter == true then
      ListenForAimDuringRecenter()
    end
    if player:HasMarker("Aiming") then
      game.Camera.SubmitCameraByName("AIM_Spline_AxeTutorial")
    else
      game.Camera.SubmitCameraByName("PLYR_Spline_AxeTutorial")
    end
    if player.Axe.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSInFlightOut and axeInFlightDone == false then
      TutAxeThrown()
      axeInFlightDone = true
    end
    if axethrownCheck and player:GetCurrentWeapon() == "Axe" then
      pad:DisableGameButton(tweaks.ePad.kPadTriangle)
      TrianglePressed()
      AxeRecalledInHand()
      axethrownCheck = false
    end
  end
end
function AxeRecalledInHand()
  if not boardsBroken then
    if L2Pressed then
      StartAiming()
    else
      AimDone()
    end
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    AxeTutorialPassed = AxeTutorialPassed
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  AxeTutorialPassed = savedInfo.AxeTutorialPassed
end
function DoesSkyExist()
  return game.FindLevel("For000_Sky")
end
function EnableLTW()
  game.FindLevel("For000_Sky"):GetGameObject("ForestLeadTheWay").Child:CallScript("Enable")
  game.FindLevel("For000_Sky"):GetGameObject("ForestYouShallNotPass").Child:CallScript("Enable")
end
function MakeBoardFall()
  GameObjects.animatedBridge:PlayAnimToEnd()
  PlayBoardFallSound()
end
function StartDecelOverride()
  game.Player.FindPlayer():SetDecelerationOverride(1.3)
end
function ShowJumpTutZone()
  game.FindLevel("For000_Sky"):GetGameObject("ForestYouShallNotPass").Child:CallScript("Disable")
  GameObjects.TUT_Jump:ShowEntityVolume()
  game.Player.FindPlayer():ClearDecelerationOverride()
end
function ShowJumpTutorialMsg()
  pad:SetJumpTutorial(true)
  TUT.JumpGaps_Tutorial()
end
function HideJumpTutorialMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  pad:SetJumpTutorial(false)
end
function StopJumpTutorialMsg()
  GameObjects.TUT_Jump:HideEntityVolume()
end
function ShowMantleTutorialMsg()
  TUT.Vault_Tutorial()
end
function HideMantleTutorialMsg()
  timers.StartLevelTimer(0.75, function()
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end)
end
function StopMantleTutorialMsg()
  GameObjects.TUT_Mantle:HideEntityVolume()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function AxeTutorialEnter()
  SetupSequence()
  pad:DisableGameButton(tweaks.ePad.kPadCircle)
end
function StartDecel()
  game.Player.FindPlayer():SetDecelerationOverride(1.1)
  LD.CallFunctionAfterDelay(function()
    game.Player.FindPlayer():ClearDecelerationOverride()
  end, 1.5)
end
function SetupSequence()
  local seq = LD.CreateCineSequence(thisLevel, GameObjects.EntZn_SonJumpDone, "Axe Throw Tutorial")
  seq:Do(function()
    if player:GetCurrentWeapon() == "Axe" then
      return
    else
      ShowEquipAxt_Tutorial()
    end
  end)
  seq:WaitForFunctionTrue(function()
    return player:GetCurrentWeapon() == "Axe"
  end)
  seq:Do(function()
    game.FindLevel("For000_Sky"):CallScript("DisableNoPass")
  end)
  seq:Do(function()
    ShowAxeAimTutorial()
  end)
  seq:StartSequence()
end
function RestoreAimButtons()
  pad:DisableGameButton(tweaks.ePad.kPadRight)
  buttonMonitor_L2Up:Start()
  buttonMonitor_L2Down:Start()
  pad:EnableGameButton(tweaks.ePad.kPadL2)
end
function AxeTutSpline_Disable()
  GameObjects.Col_StopTutBacktrack:HideCollision()
end
function ListenForAimDuringRecenter()
  if player:HasMarker("Aiming") then
    game.Camera.CancelRecenter()
    bListenForAimDuringRecenter = false
  end
end
function AdjustCameraFramingIfNecessary()
  local recenterDuration = 1.8
  local recenterTable = {
    RotationSpace = 1,
    TimeStart = 0,
    TimeDuration = recenterDuration,
    LockRecenter = 0.2,
    PitchRange = -1,
    TriggerUp = 90,
    ReturnUp = -2,
    ReturnDown = -2,
    TriggerDown = -17,
    YawRange = -1,
    TriggerLeft = 9,
    ReturnLeft = -20,
    ReturnRight = -22,
    TriggerRight = -34
  }
  game.Camera.Recenter(recenterTable)
  bListenForAimDuringRecenter = true
  timers.StartLevelTimer(recenterDuration, function()
    bListenForAimDuringRecenter = false
  end)
end
function AxeTutSpline_Enable()
  GameObjects.Col_StopTutBacktrack:ShowCollision()
  AdjustCameraFramingIfNecessary()
end
function ShowAxeAimTutorial()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  timers.StartLevelTimer(0.7, TUT.AimAxe_Tutorial)
  RestoreAimButtons()
end
function StartAiming()
  if player:GetCurrentWeapon() == "Axe" then
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end
  L2Pressed = true
  timers.StartLevelTimer(0.5, function()
    if L2Pressed and player:GetCurrentWeapon() == "Axe" then
      TUT.Throw_Tutorial()
      pad:EnableGameButton(tweaks.ePad.kPadR1)
      pad:EnableGameButton(tweaks.ePad.kPadR2)
    end
  end)
end
function AimDone()
  L2Pressed = false
  if player:GetCurrentWeapon() == "Axe" then
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  timers.StartLevelTimer(0.5, function()
    if not L2Pressed and player:GetCurrentWeapon() == "Axe" then
      TUT.AimAxe_Tutorial()
    end
  end)
end
function ShowEquipAxt_Tutorial()
  timers.StartLevelTimer(0.65, function()
    TUT.EquipAxe_Tutorial()
    pad:EnableGameButton(tweaks.ePad.kPadRight)
  end)
end
function CompleteAxeThrowTut()
  GameObjects.animatedBridge:Hide()
  pad:DisableGameButton(tweaks.ePad.kPadL2)
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  pad:DisableGameButton(tweaks.ePad.kPadTriangle)
  buttonMonitor_L2Down:Stop()
  buttonMonitor_L2Up:Stop()
  boardsBroken = true
  GameObjects.ContextAction_Son_Bridge.LuaObjectScript.Disable()
  PlaySoundBlockerBreak()
  GameObjects.TraverseLink_Jump02:ShowTraverseLink()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("120_BrokenBridge_Broken")
  end, 0.15)
end
function GapJump_Setup()
  GameObjects.CA_PreGapJump.LuaObjectScript.Enable()
  game.Audio.PlayBanter("080_JumpArrive")
  LD.CallFunctionAfterDelay(ShowJumpTutZone, 3)
  local lvl = game.FindLevel("For000_Sky")
  if lvl then
    game.FindLevel("For000_Sky"):CallScript("HideSecondTracks_ShallNotPass")
  end
end
function SonJumpStart()
  GameObjects.Sheet_KratosBridgeTut:HideCollision()
end
function GetInputMask()
  if inputMask == nil then
    local lvl = game.FindLevel("For000_Sky")
    if lvl then
      inputMask = lvl:GetGameObject("InputMask")
    end
  end
  return inputMask
end
function SonJumpComplete()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  AxeTutorialPassed = true
  GetInputMask():CallScript("AxtTut_Step_3")
  timers.StartLevelTimer(0.5, function()
    game.Audio.PlayBanter("125_BrokenForest")
  end)
  if player:GetCurrentWeapon() == "Axe" then
    timers.StartLevelTimer(2.5, function()
      pad:EnableGameButton(tweaks.ePad.kPadCircle)
    end)
  else
    timers.StartLevelTimer(0.5, ShowAxeRecallTutorialMsg)
  end
end
function TutAxeThrown()
  print("TutAxeThrown")
  pad:DisableGameButton(tweaks.ePad.kPadR1)
  pad:DisableGameButton(tweaks.ePad.kPadR2)
  timers.StartLevelTimer(0.25, function()
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end)
  timers.StartLevelTimer(1.15, CheckTutComplete)
end
function CheckTutComplete()
  print("CheckTutComplete")
  if not boardsBroken then
    if player:GetCurrentWeapon() == "Axe" then
      TrianglePressed()
    else
      ShowAxeRecallTutorialMsg()
    end
  end
  axethrownCheck = true
end
function AxeTutorialExit()
  if AxeTutorialPassed then
    kratosJumpDone = true
    GameObjects.EntZn_TutorialSpeed:HideEntityVolume()
    GameObjects.entityZone_AxeTut:HideEntityVolume()
    GameObjects.TraverseLink_tree_vault:ShowTraverseLink()
    GameObjects.TraverseLink_Jump02:HideTraverseLink()
    game.Player.FindPlayer():ClearDecelerationOverride()
  end
end
function ShowAxeRecallTutorialMsg()
  uiCalls.SendSidebarDesignerMessage({
    Text = 18027,
    AdvanceType = uiCalls.msgParam.INFINITE_TIMER,
    Critical = true
  })
  pad:EnableGameButton(tweaks.ePad.kPadTriangle)
end
function TrianglePressed()
  axeInFlightDone = false
  print("TrianglePressed")
  timers.StartLevelTimer(0.1, function()
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end)
  if boardsBroken and AxeTutorialPassed then
    pad:EnableGameButton(tweaks.ePad.kPadCircle)
  end
end
function EnableKratosCol()
  GameObjects.Sheet_KratosBridgeTut:ShowCollision()
  GameObjects.TraverseLink_tree_vault:HideTraverseLink()
end
function HideKratosCol()
  GameObjects.Sheet_KratosBridgeTut:HideCollision()
end
function ResourcesTutorialHint()
  local showHint = LD.GetEntityVariable("TUT_ShowResourceTutorialHint")
  if showHint == true then
    TUT.CollectResources_Tutorial()
    LD.SetEntityVariable("TUT_ShowResourceTutorialHint", false)
  end
end
function HideTraverseLinkForBrokenForest()
  GameObjects.TraverseLink_Jump02:HideTraverseLink()
end
function ShowTraverseLinkForBrokenForest()
  GameObjects.TraverseLink_Jump02:ShowTraverseLink()
end
function DisableSplineCamera()
  local camzone = thisLevel:GetGameObject("CamZone_AxeTutorial")
  camzone:HideCameraVolume()
end
local SNDFor500BridgeBlocker
function SoundInIt()
  SNDFor500BridgeBlocker = GameObjects.SNDGrpBridgeBreak:FindSingleSoundEmitterByName("SNDFor500BridgeBreakable")
end
function PlaySoundBlockerBreak()
  LD.PlaySound(SNDFor500BridgeBlocker, "SND_BRK_Wood_Bridge_Barricade_Explo_For500")
end
function PlaySoundCrowFlyAway()
  LD.PlaySound(GameObjects.SNDGrpCrowFlyaway:FindSingleSoundEmitterByName("SNDCrowFlyAway500_1"), "SND_AMB_EMIT_Crow_Fly_Away_With_Foliage_For000")
end
function PlayBoardFallSound()
  LD.PlaySound(SNDFor500BridgeBlocker, "SND_BRK_Wood_Pallet_Wall_Drop_For200")
end
