local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timers = require("level.timer")
local actor = require("narrative.actor")
thisLevel = nil
thisObj = nil
player = nil
local kratosActor, sonActor, cine_ActorTable, bPlayed
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  player = game.Player.FindPlayer()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  SetDefaultTraverseLinkEnabled(false)
end
function OnStart(level, obj)
  if not bPlayed then
    CreateActors()
  end
  local iz = GameObjects.InteractZone_JumpTutorial.LuaObjectScript.GetInteractZone()
  iz:DisablePrompt()
end
function OnSaveCheckpoint(level, obj)
  return {bPlayed = bPlayed}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bPlayed = savedInfo.bPlayed
end
function CreateActors()
  kratosActor = actor.Actor.New("Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("Son", game.AI.FindSon)
end
function StartFirstGapJumpSequence()
  CreateActors()
  local cine_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_FirstGapJump"
    }
  }
  local seq = ND.CreateCineSequence(thisLevel, thisObj, "firstGapJump")
  seq:ActorForceApproachAndWait(kratosActor, {
    Branch = "BRA_FirstGapJump",
    ReferenceJoint = "FirstGapJump_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    strafe_distance = 100,
    radius = ND.StopTurnRadius,
    weapon_state = "bare"
  })
  seq:ActorSync(kratosActor, {
    Slaves = cine_ActorTable,
    Branch = "BRA_FirstGapJump",
    ReferenceJoint = "FirstGapJump_SynchJoint"
  })
  seq:Do(GapJumpPassed)
  seq:WaitForActorPuppeteerComplete(kratosActor)
  seq:Do(function()
    SetDefaultTraverseLinkEnabled(true)
  end)
  seq:Do(function()
    GameObjects.Col_BumperRail_Scripted:HideCollision()
  end)
  seq:StopPuppetingActor(kratosActor)
  seq:Do(function()
    timers.StartLevelTimer(5, HidePostSpeedControlZones)
  end)
  seq:StopPuppetingActor(sonActor)
  seq:StartSequence()
end
function HidePostSpeedControlZones()
  game.Player.FindPlayer():SetAccelerationOverride(0.9)
  GameObjects.EntZn_SpeedControl_PreJump:HideEntityVolume()
  GameObjects.EntZn_SpeedControlGapJump:HideEntityVolume()
  LD.CallFunctionAfterDelay(function()
    game.Player.FindPlayer():ClearAccelerationOverride()
  end, 1)
end
function GapJumpPassed()
  game.FindLevel("For000_Sky"):GetGameObject("ForestYouShallNotPass").Child:CallScript("Enable")
  GameObjects.CA_PreGapJump.LuaObjectScript.Disable()
  GameObjects.CA_ForLedgeRunStop.LuaObjectScript.Disable()
  bPlayed = true
end
function SetDefaultTraverseLinkEnabled(value)
  if value then
    GameObjects.TraverseLink_Jump00:ShowTraverseLink()
  else
    GameObjects.TraverseLink_Jump00:HideTraverseLink()
  end
end
function FirstJumpBanter()
  if game.Level.GetVariable("CompletedCineNumber") >= 15 and game.Level.GetVariable("CompletedCineNumber") < 20 then
    game.Audio.PlayBanter("070_FirstJump")
    GameObjects.Btr_FirstJump_Group:Hide()
  end
end
function BrokenBridgeBanter()
  if game.Level.GetVariable("CompletedCineNumber") >= 20 and game.Level.GetVariable("CompletedCineNumber") < 30 then
    timers.StartLevelTimer(0.6, function()
      game.Audio.PlayBanter("120_BrokenBridge", Banter_120_Complete)
    end)
  end
end
function Banter_120_Complete()
  GameObjects.entityZone_AxeTut:ShowEntityVolume()
end
function BrokenBridgeBanter2()
  if game.Level.GetVariable("CompletedCineNumber") >= 25 and game.Level.GetVariable("CompletedCineNumber") < 30 then
    print("======== BROKEN BRIDGE BANTER 2 ==========")
    game.Audio.PlayBanter("120_BrokenBridge_Broken")
    GameObjects.Btr_BrokeBridge_Group:Hide()
  end
end
function Temp_ThirdTracksBanter()
  if game.Level.GetVariable("CompletedCineNumber") >= 15 and game.Level.GetVariable("CompletedCineNumber") < 25 then
    game.Audio.PlayBanter("080_DeerTracks")
  end
end
