local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local timers = require("level.timer")
local thisObj, thisLevel, son, sonActor, deerActor
local boolBrokenBridge = false
local boolBrokenBridgePassed = false
local DeerSurpriseBtr = "DeerSurprise"
local btrBrokenBridge = "120_BrokenBridge"
local btrBrokenBridge_Broken = "120_BrokenBridge_Broken"
local cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  son = game.AI.FindSon()
  cameraCineEnter = CCEC.CineEnterCamera.New("PLYR_Nar_DeerSurprise", 3.5, nil)
  SoundInit()
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 25 then
    SetupActors()
    SpawnDeer()
  end
end
function OnUpdate(level, obj)
  if son:IsInsideEntityZone("BtrZone_BrokenBridge") and _G.AxeTutorialPassed == false and boolBrokenBridge == false then
    game.Audio.PlayBanter(btrBrokenBridge)
    boolBrokenBridge = true
  elseif _G.AxeTutorialPassed == true and boolBrokenBridge == false then
    game.Audio.PlayBanter(btrBrokenBridge_Broken)
    boolBrokenBridge = true
    boolBrokenBridgePassed = true
  end
  if boolBrokenBridge == true and _G.AxeTutorialPassed == true and boolBrokenBridgePassed == false then
    boolBrokenBridgePassed = true
    game.Audio.PlayBanter(btrBrokenBridge_Broken)
  end
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {playedSetupBool = boolBrokenBridge, playedSetupBool = boolBrokenBridgePassed}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
  boolBrokenBridge = savedInfo.playedSetupBool
  boolBrokenBridgePassed = savedInfo.playedSetupBool
end
function SpawnDeer()
  deerActor:SetAsyncSpawn(ND.SpawnAIAtJoint_GetAsyncSpawnParams(thisLevel, "Cine_DeerSurprise", "Deer_DeerSurprise_SpawnJoint", "CRT_Deer00", "BRA_DeerSurpriseIdle", "deer"))
end
function SetupActors()
  sonActor = actor.Actor.New("DEER SURPRISE: Son Actor", game.AI.FindSon)
  deerActor = actor.Actor.New("DEER SURPRISE: Deer Actor")
end
function DeerSurpriseSequence()
  print("PLAYING DEER SURPRISE")
  local deerSurpriseSeq = LD.CreateCineSequence(thisLevel, thisObj, "Deer Surprise Sequence")
  local deerSurprise_ActorTable = {
    {
      Actor = deerActor,
      Branch = "BRA_DeerSurprise"
    }
  }
  deerSurpriseSeq:RequestCineModeAndWait(sonActor, thisObj)
  deerSurpriseSeq:Do(StartPreCineCamera)
  deerSurpriseSeq:SpawnActorAndWait(deerActor)
  deerSurpriseSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_DeerSurprise",
    ReferenceJoint = "DeerSurprise_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.SonRunArrivalRadius
  })
  deerSurpriseSeq:ActorSync(sonActor, {
    Slaves = deerSurprise_ActorTable,
    Branch = "BRA_DeerSurprise",
    ReferenceJoint = "DeerSurprise_SynchJoint"
  })
  deerSurpriseSeq:Do(PlayBridgeBreakAnimation)
  deerSurpriseSeq:Do(function()
    game.Player.FindPlayer():SetDecelerationOverride(1.2)
  end)
  deerSurpriseSeq:Do(function()
    game.Player.FindPlayer():SetAccelerationOverride(0.85)
  end)
  deerSurpriseSeq:WaitForAndCompleteCineMode(sonActor, thisObj)
  deerSurpriseSeq:StopPuppetingActor(sonActor)
  deerSurpriseSeq:Do(HideSpeedControlZone)
  deerSurpriseSeq:SetCompletedCineNumber(25)
  deerSurpriseSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  deerSurpriseSeq:WaitForActorMoveComplete(deerActor)
  deerSurpriseSeq:StopPuppetingActor(deerActor)
  deerSurpriseSeq:DespawnActor(deerActor)
  deerSurpriseSeq:StartSequence()
end
function StartPreCineCamera()
  cameraCineEnter:Start()
end
function HideSpeedControlZone()
  game.Player.FindPlayer():ClearDecelerationOverride()
  LD.CallFunctionAfterDelay(function()
    game.Player.FindPlayer():ClearAccelerationOverride()
  end, 4)
  GameObjects.SpeedControl_DeerSurprise:Hide()
  timers.StartLevelTimer(0.1, function()
    game.FindLevel("For000_Sky"):GetGameObject("InputMask"):CallScript("SetCustomInputMask")
  end)
end
function PlayBridgeBreakAnimation()
  soundBridgeBreak()
end
local soundEmitter
function SoundInit()
  soundEmitter = GameObjects.SNDGrpBridgeBreakOmen:FindSingleSoundEmitterByName("SNDBridgeBreakOmen")
end
function soundBridgeBreak()
  LD.PlaySoundAfterDelay(soundEmitter, "SND_OMEN_DeerSurprise_Bridge_For500", 6.5)
end
