local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kraActor, sonActor, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("AXE INTRO: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("AXE INTRO: Son Actor", game.AI.FindSon)
end
function AxeIntro_SetupSon()
  SetupActors()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Axe Intro Son Setup")
  cineSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_ProDraugrFightEnter",
    ReferenceJoint = "AxeIntro_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.SonRunArrivalRadius
  })
  cineSeq:ActorSync(sonActor, {
    Branch = "BRA_ProDraugrFightEnter",
    ReferenceJoint = "AxeIntro_SynchJoint"
  })
  cineSeq:WaitSeconds(1)
  cineSeq:StartSequence()
end
function AxeIntroSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Axe Intro Cine")
  local axeIntro_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_ProStartDraugrFight"
    }
  }
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:Do(StartCineEnter_DraugrIntro)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_ProStartDraugrFight",
    ReferenceJoint = "AxeIntro_SynchJoint",
    speed = ND.KraRunSpeed,
    stop = true,
    prevent_path_eval = true,
    radius = ND.RunArrivalRadius,
    weapon_state = "bare_on_back",
    ignore_navmesh = false
  })
  cineSeq:ActorSync(kraActor, {
    Slaves = axeIntro_ActorTable,
    Branch = "BRA_ProStartDraugrFight",
    ReferenceJoint = "AxeIntro_SynchJoint"
  })
  cineSeq:Do(TriggerFight)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(SonIdleDraugrFight)
  cineSeq:StartSequence()
end
function SonIdleDraugrFight()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Axe Intro Idle")
  cineSeq:RequestCineModeAndWait(sonActor, thisObj, true)
  cineSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_AfterDraugrFight",
    ReferenceJoint = "AfterDraugrFight_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = 3
  })
  cineSeq:ActorSync(sonActor, {
    Branch = "BRA_AfterDraugrFight",
    ReferenceJoint = "AfterDraugrFight_SynchJoint"
  })
  cineSeq:StartSequence()
end
function SonExitDraugrFight()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Axe Intro Exit")
  cineSeq:RequestCineModeAndWait(sonActor, thisObj, true)
  cineSeq:ActorSync(sonActor, {
    Branch = "BRA_AfterDraugrFightExit",
    ReferenceJoint = "AfterDraugrFight_SynchJoint"
  })
  cineSeq:Do(Btr_140NeverThisClose)
  cineSeq:WaitForAndCompleteCineMode(sonActor, thisObj)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:Do(function()
    GameObjects.IC_ArenaExit:HideCollision()
  end)
  cineSeq:StartSequence()
  LD.EnableContextBehaviorBanter()
end
function Btr_140NeverThisClose()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("140_NeverThisClose", _G.CombatCameraTut)
  end, 1)
end
function TriggerFight()
  local for550 = game.FindLevel("For550_BrokenForest")
  if for550 ~= nil then
    for550:CallScript("StartFirstFight")
  end
end
function DestroyCamera_DraugrIntro()
  cameraCineEnter = nil
end
function StartCineEnter_DraugrIntro()
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_DraugrIntro", 6)
  cameraCineEnter:SetCallback(DestroyCamera_DraugrIntro)
  cameraCineEnter:Start()
end
