local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local color = require("core.color")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, kratosActor, sonActor, deerActor, bLeadTheWay, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
end
function OnStart()
  if game.Level.GetVariable("CompletedCineNumber") < 30 then
    SetupActors()
    SetDeerSpawnFunction()
  end
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  local savedInfo = {}
  savedInfo.LevelState = checkpoint.Save()
  return savedInfo
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function SetDeerSpawnFunction()
  deerActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_DeerMiss", "DeerMiss_Deer_StartJoint", "CRT_Deer00", "BRA_EatIdle", "deer")
  end)
end
function SetupActors()
  kratosActor = actor.Actor.New("DEER MISS: Kratos", game.Player.FindPlayer)
  sonActor = actor.Actor.New("DEER MISS: Son", game.AI.FindSon)
  deerActor = actor.Actor.New("DEER MISS: Deer")
end
function DeerMiss_Son_Sequence()
  if game.Level.GetVariable("CompletedCineNumber") < 30 then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Deer Miss Son Sequence")
    cineSeq:ActorForceApproachAndWait(sonActor, {
      Branch = "BRA_DeerMissEnter",
      ReferenceJoint = "DeerMiss_SynchJoint",
      speed = ND.SonRunSpeed,
      stop = false,
      foot = game.Creature.Foot.kRight,
      radius = ND.SonRunArrivalRadius
    })
    cineSeq:ActorSync(sonActor, {
      Branch = "BRA_DeerMissEnter",
      ReferenceJoint = "DeerMiss_SynchJoint"
    })
    cineSeq:WaitSeconds(1)
    cineSeq:StartSequence()
  end
end
function DeerMiss_Kra_Sequence()
  if game.Level.GetVariable("CompletedCineNumber") < 30 then
    local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Deer Miss Sequence")
    local deerMiss_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_DeerMissCine"
      },
      {
        Actor = deerActor,
        Branch = "BRA_DeerMissCine"
      }
    }
    cineSeq:SetPostSkipMusic("SND_MX_PRO_start_master")
    cineSeq:MarkAbleToSkip()
    cineSeq:RequestCineModeAndWait(kratosActor, thisObj)
    cineSeq:Do(IncreaseKratosDeceleration)
    cineSeq:Do(function()
      game.FindLevel("For500_ForestEntry"):CallScript("DisableSplineCamera")
    end)
    cineSeq:Do(StartCineEnter_DeerMiss)
    cineSeq:SpawnActorAndWait(deerActor)
    cineSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_DeerMissCine",
      ReferenceJoint = "DeerMiss_SynchJoint",
      speed = ND.KraRunSpeed,
      stop = false,
      foot = game.Creature.Foot.kLeft,
      radius = ND.RunArrivalRadius,
      weapon_state = "bare_on_back"
    })
    cineSeq:ActorSync(kratosActor, {
      Slaves = deerMiss_ActorTable,
      Branch = "BRA_DeerMissCine",
      ReferenceJoint = "DeerMiss_SynchJoint"
    })
    cineSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    cineSeq:StopPuppetingActor(kratosActor)
    cineSeq:StopPuppetingActor(sonActor)
    cineSeq:StopPuppetingActor(deerActor)
    cineSeq:DespawnActor(deerActor)
    cineSeq:SetCompletedCineNumber(30)
    cineSeq:Do(ClearKratosDeceleration)
    cineSeq:Do(function()
      GameObjects.CA_Idle_NoFight_AxeTut.LuaObjectScript.Enable()
    end)
    cineSeq:Do(_G.setAxeIntroReady)
    cineSeq:Do(function()
      game.World.StoreCheckpoint()
    end)
    cineSeq:StartSequence()
  end
end
function IncreaseKratosDeceleration()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(1.2)
end
function ClearKratosDeceleration()
  game.Player.FindPlayer():ClearDecelerationOverride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
function StartCineEnter_DeerMiss()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_DeerMissIntro", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_DeerMiss)
  cameraCineEnter:Start()
end
function DestroyCineEnter_DeerMiss()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
