local EC = require("design.Encounter")
local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local color = require("core.color")
local monitors = require("level.MonitorLibrary")
thisLevel = nil
player = nil
son = nil
local Area_1_Encounter_1, WolvesLookatMonitor, AlertWolves
wolf_pit_complete = false
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  son = game.AI.FindSon()
  Wolfpit_Area_1_Fight_1()
end
function CA_WolfPit_Enable()
  GameObjects.CA_Observe_Up_01.LuaObjectScript.Enable()
  GameObjects.CA_ObserveUP_CrackClimb.LuaObjectScript.Enable()
  if not wolf_pit_complete then
    GameObjects.CA_Idle_NoCombat.LuaObjectScript.Enable()
  end
  game.FindLevel("For000_Sky"):CallScript("Disable_IntersectionLTW")
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Enable()
end
function CA_WolfPit_Disable()
  GameObjects.CA_Idle_NoCombat.LuaObjectScript.Disable()
  GameObjects.CA_Observe_Up_01.LuaObjectScript.Disable()
  GameObjects.CA_ObserveUP_CrackClimb.LuaObjectScript.Disable()
  game.FindLevel("For000_Sky"):CallScript("Enable_IntersectionLTW")
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Disable()
end
function Wolfpit_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Wolfs For550", {
    CheckpointOnComplete = true,
    LeashZone = "LeashWolfPit"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Wolf_SRFC_*",
      maxActive = 2,
      totalSpawns = 2,
      spawnCooldown = 0.1
    }
  })
  Area_1_Encounter_1:OnStart(function()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "WILL_NOT_FIGHT_BEHAVIOR_CONTEXT_CONFIG")
    game.World.StoreCheckpoint()
  end)
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Arena_1_Encounter_Start"))
  function AlertWolves()
    if player:InsideZone(GameObjects.EntZn_WolvesAlert) then
      if WolvesLookatMonitor then
        WolvesLookatMonitor:Stop()
        WolvesLookatMonitor:Terminate()
        WolvesLookatMonitor = nil
      end
      Area_1_Encounter_1:AlertEnemies(1)
    end
  end
  WolvesLookatMonitor = monitors.CreateLookAtMonitor(engine.Vector.New(-136.5, 40.1, -745.5))
  WolvesLookatMonitor:OnLookAt(AlertWolves)
  Area_1_Encounter_1:OnComplete(function()
    wolf_pit_complete = true
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Feral")
    GameObjects.CA_Idle_NoCombat.LuaObjectScript.Disable()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
    LD.CallFunctionAfterDelay(function()
      GameObjects.Banter_WolfPit_Group:ShowEntityVolume()
    end, 6)
  end)
end
