local LD = require("design.LevelDesignLibrary")
local uiCalls = require("ui.uicalls")
local TUT = require("game.GlobalTutorials")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local thisLevel, player, son
local temp_breakablecounter = 0
local Area_1_Encounter_1
function OnScriptLoaded(level)
  thisLevel = level
  SoundInit()
  GameObjects.EntZn_AvoidSplineEnable:HideEntityVolume()
end
function OnStartGameFromThisLevel(level)
end
function OnFirstStart()
  GameObjects.LootHangingBreakable_1.Child:SetEmissiveScale(5)
end
function OnStart()
  MusicOnStart()
end
function OnSaveCheckpoint(level)
  return {
    LevelState = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function ShowHealthRuneHint()
  local showHint = LD.GetEntityVariable("FOR_ShowHealthRuneHint")
  if showHint == true then
    TUT.GreenStones_Tutorial()
  end
end
function HealthPickupLearned()
  TUT.HideTutorial()
  LD.SetEntityVariable("FOR_ShowHealthRuneHint", false)
end
function Start_Spire_Fight()
  Area_1_Encounter_1:Start()
end
function Spire_Popcorn_Fight()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]Spire Popcorn Fight", {
    CheckpointOnComplete = true,
    LeashZone = "NavLeash_PopcornFight"
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_L_SPW1",
      spawnLocators = "A1_Loc_1",
      useSpawnLocatorsOnly = true,
      spawnWad = "For550_BrokenForest",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L_SPW2",
      spawnLocators = "A1_Loc_2",
      useSpawnLocatorsOnly = true,
      spawnWad = "For550_BrokenForest",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1
    },
    {
      spawners = "Draugr_L_SPW3",
      spawnLocators = "A1_Loc_3",
      useSpawnLocatorsOnly = true,
      spawnWad = "For550_BrokenForest",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_1_Encounter_1:OnStart(DisableLevelSplines)
  Area_1_Encounter_1:OnComplete(DisableAvoidSpline)
end
function DisableLevelSplines()
  game.FindLevel("For000_Sky"):CallScript("Disable_IntersectionLTW")
  GameObjects.EntZn_AvoidSplineEnable:ShowEntityVolume()
end
function EnableAvoidSpline()
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Enable()
end
function DisableAvoidSpline()
  game.FindLevel("For000_Sky"):CallScript("Enable_IntersectionLTW")
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Disable()
end
function ChestOpened()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_Observe_Forward.LuaObjectScript.Disable()
  end, 6.25)
  GameObjects.EntZn_Disable_TripleChestWait:HideEntityVolume()
  GameObjects.EntZn_Enable_TripleChestWait:HideEntityVolume()
  game.FindLevel("For000_Sky"):CallScript("LTW_Update_TripleChest")
end
local SNDDeerSpotA
function SoundInit()
  SNDDeerSpotA = GameObjects.SNDDeerSpotAGrp:FindSingleSoundEmitterByName("SNDDeerSpotA")
end
function PlaySoundDeerSpotA()
  LD.PlaySound(SNDDeerSpotA, "SND_OMEN_DeerSpotACine_For650")
end
local OverrideMusicEvents = {
  OpenedMusic = "",
  LockMusic = "",
  UnlockMusic = "SND_MX_PRO_chest_opened",
  BrokenMusic = ""
}
function MusicOnStart()
  GameObjects.chest_runic_tier1_for600_1.LuaObjectScript.MusicSetup(OverrideMusicEvents)
end
