local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timer = require("level.timer")
local color = require("core.color")
local actor = require("narrative.actor")
local CCOS = require("camera.camera_oneshot")
local thisObj, thisLevel, deerActor
local btrMagicArrow = "210_MagicArrow"
local camOneShot_LookAtDeer
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 40 then
    SetupActor()
    SpawnDeer()
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  if camOneShot_LookAtDeer ~= nil then
    local lookAtDirection = game.Camera.GetOrbitRotation()
    if -14.25 < lookAtDirection and lookAtDirection < 50.5 then
      camOneShot_LookAtDeer:Update()
    else
      DestroyOneShot_DeerSpotted()
    end
  end
end
function SpawnDeer()
  deerActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_DeerSpotA_Group", "Deer_DeerSpotA_StartJoint", "CRT_Deer00", "BRA_DeerSpotA", "deer")
  end)
end
function SetupActor()
  deerActor = actor.Actor.New("DEER SPOT A: Deer Actor")
end
function SetupCineSequence()
  local deerSpotASeq = LD.CreateCineSequence(thisLevel, thisObj, "Deer Spot A Sequence")
  deerSpotASeq:SpawnActorAndWait(deerActor)
  deerSpotASeq:ActorSync(deerActor, {
    Branch = "BRA_DeerSpotA",
    ReferenceJoint = "DeerSpotA_SynchJoint"
  })
  deerSpotASeq:WaitSeconds(1.5)
  deerSpotASeq:Do(function()
    game.Audio.PlayBanter(btrMagicArrow)
  end)
  deerSpotASeq:Do(LookAtDeer)
  deerSpotASeq:Do(PlayOmenSound)
  deerSpotASeq:WaitForAndCompleteCineMode(deerActor, thisObj)
  deerSpotASeq:WaitForActorMoveComplete(deerActor)
  deerSpotASeq:DespawnActor(deerActor)
  deerSpotASeq:SetCompletedCineNumber(40)
  deerSpotASeq:StartSequence()
end
function DestroyOneShot_DeerSpotted()
  camOneShot_LookAtDeer = nil
  game.SubObject.Sleep(thisObj)
end
function LookAtDeer()
  local lookAtDirection = game.Camera.GetOrbitRotation()
  if -14.25 < lookAtDirection and lookAtDirection < 50.5 then
    game.SubObject.Wake(thisObj)
    game.Camera.Recenter({
      TimeStart = 0,
      TimeDuration = 1,
      LockRecenter = 0.5,
      PitchRange = -1,
      TriggerUp = 8,
      ReturnUp = -1.742,
      ReturnDown = -1.742,
      TriggerDown = -7,
      YawRange = 360
    })
    camOneShot_LookAtDeer = CCOS.OneShotCamera.New("PLYR_NAR_DeerSpotted", 3)
    camOneShot_LookAtDeer:SetCallback(DestroyOneShot_DeerSpotted)
    camOneShot_LookAtDeer:Start()
    StartSlowWalk()
    timer.StartLevelTimer(3, ClearSlowWalk)
  end
end
function StartSlowWalk()
  local player = game.Player.FindPlayer()
  player:SetMaxSpeedOverride(2.9)
end
function ClearSlowWalk()
  local player = game.Player.FindPlayer()
  player:ClearMaxSpeedOverride()
end
function PlayOmenSound()
  game.FindLevel("For600_Spire"):CallScript("PlaySoundDeerSpotA")
end
