local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local EC = require("design.Encounter")
local monitors = require("level.MonitorLibrary")
local checkpoint = require("level.checkpoint")
local thisLevel, player, combatComplete, Area_1_Encounter_1, A1_E1_Alert
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  Wolf_Area_1_Fight_1()
end
function OnStartGameFromThisLevel()
end
function DoesSkyExist()
  return game.FindLevel("For000_Sky")
end
function EnableLTW()
  local for00 = game.FindLevel("For000_Sky")
  for00:GetGameObject("ForestLeadTheWay").Child:CallScript("Enable")
  for00:GetGameObject("ForestYouShallNotPass").Child:CallScript("Enable")
end
function BurnTheBarrier()
  GameObjects.flammableBramble4x2.LuaObjectScript.IgniteObject()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
end
function Wolf_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Wolf Fight For650", {
    CheckpointOnComplete = true,
    CheckpointOverrideObject = GameObjects.ChkOvr_For650BelowBridge.Child
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Wolf_ECU",
      spawnLocators = "A1_Loc_A2",
      useSpawnLocatorsOnly = true,
      spawnWad = "For660_TempleInterior",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Wolf_ECU",
      spawnLocators = "A1_Loc_A3",
      useSpawnLocatorsOnly = true,
      spawnWad = "For660_TempleInterior",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0.7
    }
  })
  Area_1_Encounter_1:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "Wolf_WPR",
      spawnLocators = "A1_Loc_D2",
      useSpawnLocatorsOnly = true,
      spawnWad = "For660_TempleInterior",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    prioritizeOnScreenSpawners = true,
    requireSpawnersInRange = {5, 30},
    {
      spawners = "Draugr_M_SFG",
      spawnLocators = "A1_Loc_C*",
      useSpawnLocatorsOnly = true,
      spawnWad = "For660_TempleInterior",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Spawn"))
  A1_E1_Alert = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZnAlert)
  A1_E1_Alert:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies(1)
    game.AI.FindSon():CallScript("EnterBehaviorContext", "WILL_NOT_FIGHT_BEHAVIOR_CONTEXT_CONFIG")
  end)
  Area_1_Encounter_1:OnComplete(Area1CombatComplete)
end
function Flyers_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 2]EC:1 Flyer Fight For650", {CheckpointOnComplete = true})
  Area_1_Encounter_1:AddWave({
    requiredWaveCompletion = 49,
    {
      spawners = "Flyer_SUA_*",
      maxActive = 3,
      initialSpawnCooldown = 0.1,
      initialSpawnAmount = 3,
      totalSpawns = 3,
      spawnCooldown = {3, 5}
    }
  })
  Area_1_Encounter_1:AddWave({
    requireOffScreenSpawners = true,
    {
      spawners = "Flyer_SPA",
      spawnLocators = "A1_Loc_*",
      useSpawnLocatorsOnly = true,
      maxActive = 2,
      initialSpawnCooldown = 0.1,
      initialSpawnAmount = 2,
      totalSpawns = 2,
      spawnCooldown = {2, 3}
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area_1_Spawn"))
  Area_1_Encounter_1:OnComplete(Area1CombatComplete)
end
function Area1CombatComplete()
  LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Wolf_Feral")
  GameObjects.CA_Idle_NoCombat.LuaObjectScript.Disable()
  if game.Level.GetVariable("CompletedCineNumber") < 72 then
    timers.StartLevelTimer(3, function()
      game.Audio.PlayBanter("240_E3Pond")
    end)
  end
  combatComplete = true
  GameObjects.EntZnAlert:HideEntityVolume()
  GameObjects.ca_combat_turret_01.LuaObjectScript.Disable()
  GameObjects.ca_combat_turret_02.LuaObjectScript.Disable()
  GameObjects.ca_combat_turret_03.LuaObjectScript.Disable()
  GameObjects.LTW_NoFight.LuaObjectScript.Disable()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "WAIT_AND_EXPLORE_BEHAVIOR_CONTEXT_CONFIG")
end
function CA_Enable_Door()
  GameObjects.CA_Idle_PreDoor.LuaObjectScript.Enable()
end
function CA_Disable_Door()
  GameObjects.CA_Idle_PreDoor.LuaObjectScript.Disable()
end
function CA_BridgeAreaReturn_Enter()
  GameObjects.CA_Forward_01.LuaObjectScript.Enable()
  GameObjects.CA_ObserveFar_01.LuaObjectScript.Enable()
  GameObjects.CA_BoatLookat.LuaObjectScript.Enable()
  if not combatComplete then
    GameObjects.CA_Idle_NoCombat.LuaObjectScript.Enable()
  end
  GameObjects.LTW_NoFight.LuaObjectScript.Enable()
end
function CA_BridgeAreaReturn_Exit()
  GameObjects.CA_Idle_NoCombat.LuaObjectScript.Disable()
  GameObjects.CA_Forward_01.LuaObjectScript.Disable()
  GameObjects.CA_ObserveFar_01.LuaObjectScript.Disable()
  GameObjects.LTW_NoFight.LuaObjectScript.Disable()
  GameObjects.CA_BoatLookat.LuaObjectScript.Disable()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "LEAD_THE_WAY_BEHAVIOR_CONTEXT_CONFIG")
end
