local EC = require("design.Encounter")
local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local timer = require("level.timer")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local LM = require("level.loadmonitor")
local thisLevel, player
local camShakeLarge = {
  EffectName = "FSE_shake_temp_Generic_Large",
  Duration = 1
}
local ForceFeedbackRumble = {
  EffectName = "FFB_HEAVY_ATTACK",
  Duration = 1
}
local zoneMonitor1, buttonMonitor1, timer_AxeTrainingZoom, bStopHandHolding, sonPup, syncPos, syncDir, switchParams, LoadingDoorWad, LeadTheWayWad, enemySpawned, healthTutorialDone, Gate01, Gate02, GateAnimMonitor
local SonCurrentZone = 0
local PlayerCurrentZone, GateIsFree
local cameraTempleRecenter = {
  TimeStart = 0,
  TimeDuration = 1.3,
  LockRecenter = 0.46,
  YawRange = -1,
  TriggerLeft = 84,
  ReturnLeft = 84,
  ReturnRight = 80,
  TriggerRight = 80,
  PitchRange = -1,
  TriggerUp = 9,
  ReturnUp = 9,
  ReturnDown = 5,
  TriggerDown = 5,
  RotationSpace = 1
}
local Area_1_Encounter_1
local tutorialTriggered = false
local Turret_Draugr_HealthMonitor, ZM_A1_E1_Alert, EnemyLookatMonitor, AlreadyLookingMonitor, R1_ButtonMonitor, R2_ButtonMonitor
function OnScriptLoaded(level)
  thisLevel = level
  player = game.Player.FindPlayer()
  Wolf_Area_1_Fight_1()
  timer_AxeTrainingZoom = timer.StartLevelTimer(3, StopSubmittingCamera)
  timer_AxeTrainingZoom:Stop()
  bStopHandHolding = false
  Gate01 = GameObjects.Gate_grp_01
  Gate02 = GameObjects.Gate_grp_02
  GateAnimMonitor = monitors.CreateAnimFrameMonitor(Gate01)
  GateAnimMonitor:OnFrameBackward(30, PlayerPosCheckPinCheck)
  GateAnimMonitor:OnFrameBackward(3, PlayerPosCheckPinCheckBottom)
  SoundInit()
  GameObjects.EntZn_AvoidEnemies_Enable:HideEntityVolume()
  GameObjects.EntZn_AvoidEnemies_Disable:HideEntityVolume()
  GameObjects.SonGateCrawlZone:HideEntityVolume()
  GameObjects.Exit_Gate_puzzle:FindSingleGOByName("ChainPullOfficial_For660").LuaObjectScript.OverrideDefaultCameraPitch(true, 5)
  GameObjects.Exit_Gate_puzzle:FindSingleGOByName("ChainPullOfficial_For660").LuaObjectScript.OverrideDefaultCameraRecenter(true, cameraTempleRecenter)
end
function OnPreStart(level)
  GameObjects.gateForest_GearsChain.Child:StartAnim("envFor660ChainPull")
  GameObjects.gateForest_GearsChain.Child:PauseAnim()
  GameObjects.liftgate_sideRoom_high.LuaObjectScript.ExcludeSon()
  GameObjects.liftgate_sideRoom.LuaObjectScript.ExcludeSon()
end
function OnFirstStart(level)
  PlayerCurrentZone = 0
  GateIsFree = true
end
function OnStart(level)
  local monitor = LM.CreateLoadMonitor()
  monitor:AddCallback({
    Wads = {"For000_Sky"},
    Functions = {
      GetLeadTheWayWad
    }
  })
  if Area_1_Encounter_1:WasRunning() then
    Area_1_Encounter_1:Start()
  end
end
function OnUpdate(level)
  if enemySpawned and not healthTutorialDone then
    HealthBarTutorial()
  end
  CameraLevelUpdates()
  if game.Combat.GetCombatStatus() and Area_1_Encounter_1:IsRunning() and tutorialTriggered == false then
    tutorialTriggered = true
    TempleFightInCombat()
  end
end
local testOnScreenPromptInfo = {
  conditionMet = false,
  GetConditionAlreadyMet = function(this)
    return this.conditionMet
  end,
  OnConditionMet = function(this)
    LD.CallFunctionAfterDelay(TUT.HealthBar_Tutorial, 0.5)
    healthTutorialDone = true
    this.conditionMet = true
  end,
  time = 0,
  raycastOptions = game.CollisionType.New("kInvisibleBarrier", "kEnvironment")
}
function HealthTutorialComplete()
  LD.CallFunctionAfterDelay(StartEnemyThrowTut, 0.5)
  if player:GetCurrentWeapon() ~= "Axe" and player:GetCurrentWeapon() ~= "Blades" then
    LD.PlayMove(player, GameObjects.A1_Loc_A1, "MOV_GlobalRecall")
  end
end
function HealthBarTutorial()
  if not testOnScreenPromptInfo:GetConditionAlreadyMet() then
    local didIt = false
    local crtArr = player:FindEnemies(40)
    if 0 < #crtArr then
      for _, enemy in ipairs(crtArr) do
        if game.Camera.GetViewPenetration(enemy:GetWorldPosition(), 0, 0) > 0.5 then
          local playerPos = player:GetWorldPosition()
          local enemyPos = enemy:GetWorldPosition()
          playerPos.y = playerPos.y + 1
          enemyPos.y = enemyPos.y + 1
          if not game.World.RaycastCollision(playerPos, enemyPos, {
            EntityType = testOnScreenPromptInfo.raycastOptions,
            SourceGameObject = player,
            ExcludeGameObject = enemy,
            FindAnything = true
          }) then
            testOnScreenPromptInfo:OnConditionMet()
            didIt = true
            break
          end
        end
      end
    end
    if not didIt then
      if testOnScreenPromptInfo.time > 60 then
        testOnScreenPromptInfo:OnConditionMet()
      else
        testOnScreenPromptInfo.time = testOnScreenPromptInfo.time + player:GetUnitTime()
      end
    end
  end
end
function ForceHealthTut()
  if not healthTutorialDone then
    TUT.HealthBar_Tutorial()
    LD.CallFunctionAfterDelay(StartEnemyThrowTut, 1.5)
    healthTutorialDone = true
  end
end
function InsideExitZone()
  GameObjects.entityZone03:HideEntityVolume()
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    healthTutorialDone = healthTutorialDone,
    GateIsFree = GateIsFree
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  healthTutorialDone = savedInfo.healthTutorialDone
  GateIsFree = savedInfo.GateIsFree
end
function ShowChainTutorialMsg()
end
function HideChainTutorialMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function StopChainTutorialMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function ShowAxePinTutorialMsg()
  if GateIsFree and game.Level.GetVariable("CompletedCineNumber") < 100 then
    TUT.AimAxeReminder_Tutorial()
  end
end
function HideAxePinTutorialMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function ShowRecallTutorialMsg()
  if not GateIsFree and PlayerCurrentZone == 2 and game.Level.GetVariable("CompletedCineNumber") < 100 then
    TUT.RecallAxe_Tutorial()
    buttonMonitor1 = monitors.CreateTriangleButtonMonitor()
    buttonMonitor1:OnButtonDown(HideRecallTutorialMsg)
  end
end
function HideRecallTutorialMsg()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  if buttonMonitor1 ~= nil then
    buttonMonitor1:Stop()
  end
end
function PlatformAtStart()
  PlayGateStartSound()
end
function PlatformAtEnd()
  StopChainTutorialMsg()
  timer.StartLevelTimer(1.25, ShowAxePinTutorialMsg)
  PlayGateStopSound()
end
function PinPlatform()
  if Gate01.AnimFrame > 90 then
    GameObjects.CA_WaitBetweenGates.LuaObjectScript.Enable()
    GameObjects.CA_WaitBeforeGate1.LuaObjectScript.Disable()
    GameObjects.Col_BetweenGates:ShowCollision()
  end
  LD.CallFunctionAfterDelay(HideAxePinTutorialMsg, 0.25)
  PlayGatePinSound()
  GateIsFree = false
end
function GetLeadTheWayWad()
  if LeadTheWayWad == nil then
    LeadTheWayWad = game.FindLevel("For000_Sky")
  end
  return LeadTheWayWad
end
function UnpinPlatform()
  GateIsFree = true
  GameObjects.Col_BetweenGates:HideCollision()
  if PlayerCurrentZone == 2 then
    timer.StartLevelTimer(1.3, function()
      GameObjects.CA_WaitBetweenGates.LuaObjectScript.Interrupt()
      GameObjects.CA_WaitBetweenGates.LuaObjectScript.Disable()
      GetLeadTheWayWad():CallScript("SwitchTo_TempleSpline")
      GetLeadTheWayWad():CallScript("Idle_Context_LeadTheWay")
    end)
  end
end
function DraugrIntro_ShallNotPass()
  GetLeadTheWayWad():CallScript("TempleShallNotPass_Enable")
end
function DraugrIntro_AllowPass()
  GetLeadTheWayWad():CallScript("TempleShallNotPass_Disable")
end
function HideCrawlBackThroughGateZone()
  GameObjects.SonGateCrawlZone:HideEntityVolume()
end
function CrawledBackThroughGate()
  GameObjects.CA_WaitBeforeGate1.LuaObjectScript.Enable()
  GameObjects.SonGateCrawlZone:HideEntityVolume()
  GameObjects.GateCrawl_1:FindSingleGOByName("Point_A").LuaObjectScript.Disable()
end
function ResetDoorCA()
  if GateIsFree then
    GameObjects.CA_WaitBeforeGate1.LuaObjectScript.Enable()
    GameObjects.SonGateCrawlZone:HideEntityVolume()
    GameObjects.GateCrawl_1:FindSingleGOByName("Point_A").LuaObjectScript.Disable()
  end
end
function PlayerPosCheckPinCheck()
  if PlayerCurrentZone == 1 then
    GameObjects.GateCrawl_1.LuaObjectScript.TriggerCrawl()
    GameObjects.CA_WaitBetweenGates.LuaObjectScript.Interrupt()
    GameObjects.CA_WaitBetweenGates.LuaObjectScript.Disable()
    if SonCurrentZone == 2 then
      GameObjects.SonGateCrawlZone:ShowEntityVolume()
    end
  end
end
function PlayerPosCheckPinCheckBottom()
  if PlayerCurrentZone == 1 and SonCurrentZone == 1 then
    GameObjects.CA_WaitBeforeGate1.LuaObjectScript.Enable()
  elseif PlayerCurrentZone == 2 then
    GameObjects.Btr_ChainGate.LuaObjectScript.PuzzleWinGateOpen()
  end
end
function RecallCheck()
  LD.CallFunctionAfterDelay(ShowRecallTutorialMsg, 3)
end
function SideGateLifted()
  GameObjects.ChainPullOfficial_For660.LuaObjectScript.RemoveAnimSynchedObject("SideRoomGateAnim")
  GameObjects.SideGate_IC:HideCollision()
  SetupSound_SideGateLifted()
end
function BackTrackToLiftGate()
  GameObjects.CA_Idle_UpperRope1.LuaObjectScript.Interrupt()
  GameObjects.CA_Idle_UpperRope1.LuaObjectScript.Disable()
  GameObjects.CA_GatePuzzleReturn.LuaObjectScript.Enable()
  GameObjects.CA_WaitBeforeGate1.LuaObjectScript.Enable()
  game.AI.FindSon():CallScript("ClearBehaviorContext")
end
function SonInZone1()
  SonCurrentZone = 1
end
function SonInZone2()
  SonCurrentZone = 2
end
function PlayerInZone1()
  PlayerCurrentZone = 1
  GameObjects.Btr_ChainGate.LuaObjectScript.BtrPlayerInZone1()
  GetLeadTheWayWad():CallScript("TempleShallNotPass_Disable")
end
function PlayerInZone2()
  PlayerCurrentZone = 2
  GameObjects.Btr_ChainGate.LuaObjectScript.BtrPlayerInZone2()
  if GateIsFree == true then
    timer.StartLevelTimer(0.6, function()
      GameObjects.CA_WaitBetweenGates.LuaObjectScript.Interrupt()
      GameObjects.CA_WaitBetweenGates.LuaObjectScript.Disable()
    end)
  end
  GameObjects.CA_GatePuzzleReturn.LuaObjectScript.Disable()
  GetLeadTheWayWad():CallScript("TempleShallNotPass_Enable")
end
function PlayerInZone3()
  PlayerCurrentZone = 3
  HideCrawlBackThroughGateZone()
end
function DisablePuzzleReturnCA()
  GameObjects.CA_GatePuzzleReturn.LuaObjectScript.Interrupt()
  GameObjects.CA_GatePuzzleReturn.LuaObjectScript.Disable()
end
function StopSubmittingCamera()
  bStopHandHolding = true
end
function SetSonOccupied()
  game.AI.FindSon():CallScript("EnterBehaviorContext", "WILL_NOT_FIGHT_BEHAVIOR_CONTEXT_CONFIG")
  local availabilityState = {Unoccupied = false, AvailableForCombat = false}
  game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_NoFight.LuaObjectScript.Enable()
  end, 0.2)
end
function CameraLevelUpdates()
  if bStopHandHolding == false and game.World.IsInsideCameraZone(player.WorldPosition, "CZ_ChainTrainingArea") and player:IsPlayingMove("MOV_ChainPull_AimStart") then
    timer_AxeTrainingZoom:Start()
    bStopHandHolding = true
  end
  if timer_AxeTrainingZoom.running == true and timer_AxeTrainingZoom.fired == false then
    game.Camera.SubmitCameraByName("PLYR_For660_LookCloserAtGears")
  end
end
function TriggerBacktrack()
end
function TempleFightInCombat()
  GameObjects.CA_NoFight.LuaObjectScript.Disable()
  AvoidSpline_Enable()
  Draugr_Jump1()
end
function Wolf_Area_1_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Wolfs For660", {
    CheckpointOnComplete = true,
    StartMusic = "SND_MX_PRO_fight_2_in",
    StopMusic = "SND_MX_PRO_fight_2_out",
    LeashZone = "NavLeashing_TempleInt"
  })
  Area_1_Encounter_1:AddWave({
    timeBeforeNextWave = 0.1,
    {
      spawners = "Draugr_L_Spawn",
      markerID = "StunnedEnemy",
      spawnLocators = "A1_Loc_A1",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Patrol_Draugr_L_SP",
      markerID = "StunnedEnemy",
      spawnLocators = "A1_Loc_A2",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L_Spawn",
      markerID = "StunnedEnemy",
      spawnLocators = "A1_Loc_A3",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 1.7
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "U_Draugr_L_SFG",
      markerID = "TauntDraugr1",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    triggerWaveFromScript = true,
    {
      spawners = "A_Draugr_L_SFG",
      markerID = "TauntDraugr2",
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 3
    }
  })
  Area_1_Encounter_1:AddWave({
    requireSpawnersInRange = {5, 30},
    {
      spawners = "Draugr_L_SGC",
      spawnLocators = "A1_Loc_B*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    },
    {
      spawners = "Draugr_L_SGC",
      spawnLocators = "A1_Loc_B*",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 2
    }
  })
  Area_1_Encounter_1:SetStartZone(thisLevel:GetGameObject("EntZn_Area1_DraugrSpawn"))
  Area_1_Encounter_1:OnEnemySpawn(Turret_Draugr_Health_Encounter2, {
    markerID = "TauntDraugr2"
  })
  Area_1_Encounter_1:OnStart(function()
    enemySpawned = true
    DraugrIntro_AllowPass()
  end)
  ZM_A1_E1_Alert = monitors.CreateEntityZoneMonitor(player, GameObjects.EntZn_AlertWave1)
  ZM_A1_E1_Alert:OnEnter(function()
    Area_1_Encounter_1:AlertEnemies(1)
  end)
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:AlertEnemies(1)
  end, {
    markerID = "TauntDraugr1"
  })
  Area_1_Encounter_1:OnEnemyDeath(function()
    local thisAIA = LD.FindSingleAIByMarker("TauntDraugr1")
    if thisAIA ~= nil and thisAIA:PickupIsAcquired("TurretMode") then
      thisAIA:ForceMove("BRA_SpawnFromAbove02")
      thisAIA:PickupRelinquish("TurretMode")
    end
    Area_1_Encounter_1:StartWave(3)
  end, {count = 2})
  Area_1_Encounter_1:OnEnemyDeath(function()
    Area_1_Encounter_1:StartWave(4)
  end, {count = 3})
  Area_1_Encounter_1:OnEnemyDeath(function()
    local thisAIB = LD.FindSingleAIByMarker("TauntDraugr2")
    LD.CallFunctionAfterDelay(function()
      if thisAIB ~= nil and thisAIB:PickupIsAcquired("TurretMode") then
        thisAIB:ForceMove("BRA_SpawnFromAbove02")
        thisAIB:PickupRelinquish("TurretMode")
        Area_1_Encounter_1:AlertEnemies(3)
      end
    end, 4)
  end, {count = 6})
  Area_1_Encounter_1:OnComplete(function()
    LD.UnlockBestiaryEntry_EndOfEncounter("Bestiary_Unlock_Draugr_Base")
    GameObjects.EntZn_Axe_Look_Monitor:HideEntityVolume()
    GameObjects.CA_NoFight.LuaObjectScript.Disable()
    game.AI.FindSon():CallScript("ClearBehaviorContext")
    LD.CallFunctionAfterDelay(function()
      uiCalls.UI_Event_TurnOffDesignerMessage()
    end, 0.25)
    local availabilityState = {Unoccupied = true, AvailableForCombat = false}
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
    game.AI.FindSon():CallScript("EnterBehaviorContext", "PUZZLED_BEHAVIOR_CONTEXT_CONFIG")
    FightCompleteDelay()
    GameObjects.DraugrIntro_NoPass:HideEntityVolume()
    GameObjects.DraugrIntro_CanPass:HideEntityVolume()
  end)
end
function StartEnemyThrowTut()
  TUT.AimAxeReminder_Tutorial()
  LD.CallFunctionAfterDelay(function()
    uiCalls.UI_Event_TurnOffDesignerMessage()
  end, 14)
end
function Draugr_Jump1()
  local thisAIA = LD.FindSingleAIByMarker("TauntDraugr1")
  if thisAIA ~= nil then
    thisAIA:ForceMove("BRA_SpawnFromAbove02")
  end
end
local Draugr_Jump2 = function()
  local thisAIB = LD.FindSingleAIByMarker("TauntDraugr2")
  if thisAIB ~= nil and thisAIB:PickupIsAcquired("TurretMode") then
    thisAIB:ForceMove("BRA_SpawnFromAbove02")
    thisAIB:PickupRelinquish("TurretMode")
  end
end
function Turret_Draugr_Health_Encounter2(Enemy)
  if Enemy ~= nil then
    local Draugr_Health = Enemy:GetHitPoints()
    Turret_Draugr_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = 24
    Turret_Draugr_HealthMonitor:OnHealthLessThan(Health_Phase_1, Draugr_Jump2)
  end
end
function FightCompleteDelay()
  AvoidSpline_Disable()
  GameObjects.CA_WaitBeforeGate1.LuaObjectScript.Enable()
  EnableAllGates()
end
function SonSpottedEnemies()
  GameObjects.EnvEvent_Threat.LuaObjectScript.Trigger()
end
function AvoidSpline_Enable()
  GetLeadTheWayWad():CallScript("Disable_TempleSpline")
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Enable()
  GameObjects.EntZn_AvoidEnemies_Enable:ShowEntityVolume()
  GameObjects.EntZn_AvoidEnemies_Disable:ShowEntityVolume()
  GameObjects.ca_combat_turret_02.LuaObjectScript.Enable()
end
function AvoidSpline_Disable()
  GameObjects.EntZn_AvoidEnemies_Enable:HideEntityVolume()
  GameObjects.EntZn_AvoidEnemies_Disable:HideEntityVolume()
  GameObjects.LTW_AvoidEnemies.LuaObjectScript.Disable()
  GetLeadTheWayWad():CallScript("SwitchTo_TempleSpline")
  GameObjects.ca_combat_turret_02.LuaObjectScript.Disable()
end
function EnableAllGates()
  GameObjects.CA_WaitBeforeGate1.LuaObjectScript.Enable()
  LoadingDoorWad = game.FindLevel("For666_LoadingDoor")
  LoadingDoorWad:CallScript("OpenDoors")
  LoadingDoorWad = game.FindLevel("For000_Sky")
  LoadingDoorWad:CallScript("DisableNoPass")
end
function LiftDoorBlockersRemoved()
  timer.StartLevelTimer(0.1, function()
    LD.BreakObject(GameObjects.Large_Rock_Breakable_01)
    LD.BreakObject(GameObjects.Large_Rock_Breakable_04)
    LD.BreakObject(GameObjects.Large_Rock_Breakable_05)
  end)
  timer.StartLevelTimer(2, function()
    GameObjects.liftgate_sideRoom_high.LuaObjectScript.Enable()
  end)
end
function SidePorExploded()
  timer.StartLevelTimer(0.1, function()
    LD.BreakObject(GameObjects.Large_Rock_Breakable_02)
  end)
end
local soundGate01Emitter, soundGate02Emitter, soundGate03Emitter, soundGatePinEmitter
local crankState = "Rest"
function SoundInit()
  soundGate01Emitter = Gate01:FindSingleSoundEmitterByName("SNDGate01")
  soundGate02Emitter = Gate02:FindSingleSoundEmitterByName("SNDGate02")
  soundGate03Emitter = GameObjects.SideRoomGateAnim:FindSingleSoundEmitterByName("SNDGate03")
  soundGatePinEmitter = GameObjects.SNDGatePinGroup:FindSingleSoundEmitterByName("SNDGatePin")
end
function PlayGateForwardSounds()
  print("PlayGateForwardSounds")
  if crankState ~= "Forward" then
    LD.PlaySound(soundGate01Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up", true)
    LD.PlaySound(soundGate03Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Start_Up", true)
    LD.PlaySound(soundGate01Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP", true)
    LD.PlaySound(soundGate02Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP", true)
    crankState = "Forward"
  end
end
function PlayGateBackwardSounds()
  print("PlayGateBackwardSounds")
  if crankState ~= "Backward" then
    LD.PlaySound(soundGate01Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Start_Down", true)
    LD.PlaySound(soundGate03Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Start_Down", true)
    LD.PlaySound(soundGate01Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP", true)
    LD.PlaySound(soundGate02Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP", true)
    LD.PlaySound(soundGate03Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP", true)
    crankState = "Backward"
  end
end
function PlayGateStartSound()
  print("PlayGateStartSound")
  LD.PlaySound(soundGate01Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ground")
  LD.PlaySound(soundGate02Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling")
  LD.PlaySound(soundGate03Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ground")
  StopGateSounds()
  crankState = "Rest"
end
function PlayGateStopSound()
  print("PlayGateStopSound")
  StopGateSounds()
  LD.PlaySound(soundGate01Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling", true)
  LD.PlaySound(soundGate03Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ceiling", true)
  crankState = "Rest"
end
function StopGateSounds()
  print("StopGateSounds")
  if GetCurrentCycle() == 1 and crankState == "Rest" then
    LD.PlaySound(soundGate02Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_Hit_Ground")
  end
  if crankState ~= "Rest" then
    LD.StopSound(soundGate01Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP")
    LD.StopSound(soundGate02Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP")
    LD.StopSound(soundGate03Emitter, "SND_DOOR_Metal_Lift_Gate_Forest_LP")
  end
  crankState = "Rest"
end
function PlayGatePinSound()
  StopGateSounds()
  LD.PlaySound(soundGatePinEmitter, "SND_MECH_Metal_Gate_Axe_Locked_For660")
end
function PlayGateUnPinSound()
  LD.PlaySound(soundGatePinEmitter, "SND_MECH_Metal_Gate_Axe_Unlocked_For660")
end
function GetCurrentCycle()
  return GameObjects.ChainPullOfficial_For660.LuaObjectScript.GetCurrentCycle()
end
function SetupSound_SideGateLifted()
  soundGate03Emitter = nil
  GameObjects.SideRoomGateAnim:HideAudio()
end
