local LD = require("design.LevelDesignLibrary")
local collisionCheck = require("camera.collisioncheck")
local timers = require("level.timer")
local monitors = require("level.MonitorLibrary")
local thisObj, player
local playerZone = 0
local axeHitBool = false
local varCountDetach = 0
local btrPlayedTab = {
  linger = false,
  firstInteract = false,
  noFreeze = false,
  gearHint = false,
  gearFrozen = false,
  tooSoon = false,
  secondGate = false,
  success = false
}
local sonZoneMonitor, gateObj, chainObj, GateAnimMonitor
local HudToggle = true
local penDepth = 0.5
local verticalP = 0
local horizontalP = 0
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  gateObj = GameObjects.Exit_Gate_puzzle:FindSingleGOByName("Gate_grp_01")
  chainObj = GameObjects.Exit_Gate_puzzle:FindSingleGOByName("ChainPullOfficial_For660")
  GateAnimMonitor = monitors.CreateAnimFrameMonitor(gateObj)
  GateAnimMonitor:OnFrameBackward(5, BtrGateClosed)
  GateAnimMonitor:Stop()
end
function OnStart(level, obj)
end
function OnUpdate(level, obj)
  if varCountDetach == 3 and btrPlayedTab.noFreeze and not btrPlayedTab.gearFrozen and not btrPlayedTab.gearHint and collisionCheck.isTargetInFrustumUnobstructed(GameObjects.Btr_GearHint_Marker:GetWorldPosition(), horizontalP, verticalP, penDepth, HudToggle) then
    btrPlayedTab.gearHint = true
    game.Audio.PlayBanter("250_ChainGate_GearHint")
  end
  if not btrPlayedTab.gearFrozen and axeHitBool and chainObj.LuaObjectScript:CrankIsLocked() and gateObj.AnimFrame > 0 then
    btrPlayedTab.gearFrozen = true
    game.Audio.PlayBanter("250_ChainGate_GearFrozen")
    GateAnimMonitor:Start()
  end
end
function OnSaveCheckpoint(level, obj)
  return {playedTab = btrPlayedTab}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  btrPlayedTab = savedInfo.playedTab
end
function AxeEmbed()
  if not axeHitBool then
    axeHitBool = true
  end
end
function AxeUnembed()
  if axeHitBool then
    axeHitBool = false
  end
end
function PuzzleWinGateOpen()
  if not btrPlayedTab.success and player:IsInsideEntityZone("Btr_PlayerBetweenGates") then
    btrPlayedTab.success = true
    game.Audio.PlayBanterNonCritical("250_ChainGate_Success")
  end
end
function BtrGateClosed()
  if not btrPlayedTab.tooSoon and playerZone == 1 then
    btrPlayedTab.tooSoon = true
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("250_ChainGate_TooSoon")
    end, 1)
    GateAnimMonitor:Stop()
  end
end
function chainGateFirstTime()
  if not btrPlayedTab.firstInteract then
    btrPlayedTab.firstInteract = true
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("250_ChainGate_FirstInteract")
    end, 0.75)
  end
end
function PlayLingerBtr()
  if not btrPlayedTab.linger and not btrPlayedTab.firstInteract then
    game.Audio.PlayBanter("250_ChainGate_Linger", nil, nil, false)
  end
end
function ChainPullDetached()
  if varCountDetach < 3 then
    varCountDetach = varCountDetach + 1
  end
  if gateObj.AnimFrame > 0 and not axeHitBool and not btrPlayedTab.noFreeze and not btrPlayedTab.gearFrozen then
    btrPlayedTab.noFreeze = true
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("250_ChainGate_NoFreeze")
    end, 0.75)
  end
end
function Btr_PlayerBetweenGates()
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanterNonCritical("250_ChainGate_SecondGate", _G.RecallCheck)
  end, 0.5)
end
function BtrPlayerInZone1()
  playerZone = 1
end
function BtrPlayerInZone2()
  playerZone = 2
end
