local LD = require("design.LevelDesignLibrary")
local checkpoint = require("level.checkpoint")
function OnStart(level)
end
function OnSaveCheckpoint(level)
  return {
    LevelState = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function LockDoors()
  GameObjects.Door2Lake.LuaObjectScript.Lock()
  GameObjects.SpreadDoor_StoneMason.LuaObjectScript.Lock()
end
function UnlockDoors()
  GameObjects.Door2Lake.LuaObjectScript.Unlock()
  GameObjects.SpreadDoor_StoneMason.LuaObjectScript.Unlock()
end
function OpenDoors()
  GameObjects.Door2Lake.LuaObjectScript.Enable()
end
function LowerDoorSyncExitTempleSide()
  game.FindLevel("For650_Bridge"):CallScript("CA_BridgeAreaReturn_Exit")
  game.FindLevel("For000_Sky"):CallScript("SwitchTo_TempleSpline")
  local for660_Temple = game.FindLevel("For660_TempleInterior")
  if for660_Temple ~= nil then
    for660_Temple:CallScript("ResetDoorCA")
  end
end
function LowerSyncExitLakeSide()
  game.FindLevel("For650_Bridge"):CallScript("CA_BridgeAreaReturn_Enter")
  game.FindLevel("For000_Sky"):CallScript("Disable_TempleSpline")
end
function EnterTemple()
  local for000Sky = game.FindLevel("For000_Sky")
  if for000Sky ~= nil then
    for000Sky:CallScript("SwitchTo_TempleSpline")
    for000Sky:CallScript("Idle_Context_LeadTheWay")
  end
  if game.Level.GetVariable("CompletedCineNumber") >= 50 then
    GameObjects.CA_ExitTemple.LuaObjectScript.Disable()
    GameObjects.CA_EnterTemple.LuaObjectScript.Enable()
  end
end
function ExitTemple()
  game.FindLevel("For000_Sky"):CallScript("Enable_IntersectionLTW")
  game.FindLevel("For000_Sky"):CallScript("Disable_TempleSpline")
  if game.Level.GetVariable("CompletedCineNumber") >= 50 then
    GameObjects.CA_EnterTemple.LuaObjectScript.Disable()
    GameObjects.CA_ExitTemple.LuaObjectScript.Enable()
  end
end
