local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timer = require("level.timer")
local color = require("core.color")
local actor = require("narrative.actor")
local CCEC = require("camera.camera_cineentercamera")
local thisObj, thisLevel, player, doorObj, kratosActor, sonActor, deerActor, templeLeadTheWay, bLeadTheWay, cameraCineEnter
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  game.SubObject.Sleep(thisObj)
end
function OnStart(level, obj)
  if game.Level.GetVariable("CompletedCineNumber") < 50 then
    SetupActors()
    SetSpawnFunctions()
  end
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
end
function SetupActors()
  kratosActor = actor.Actor.New("DEER SPOT B: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("DEER SPOT B: Son Actor", game.AI.FindSon)
  deerActor = actor.Actor.New("DEER SPOT B: Deer Actor")
end
function SetSpawnFunctions()
  deerActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_DeerSpotB", "DeerSpotB_Deer_SpawnJoint", "CRT_Deer00", "BRA_EatIdle", "deer")
  end)
end
function SetupCineSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 50 then
    doorObj = GameObjects.RefNodes:FindSingleGOByName("SpreadDoor_StoneMason").Child
    local deerSpotBSeq = LD.CreateCineSequence(thisLevel, doorObj, "Deer Spot B Sequence")
    local deerSpotB_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_DeerSpotBCine"
      },
      {
        Actor = deerActor,
        Branch = "BRA_DeerSpotBCine"
      },
      {
        Obj = doorObj,
        Anim = "narForDeerSpotB020CineScene"
      }
    }
    doorObj.LuaObjectScript.EnableCinematicTrigger()
    deerSpotBSeq:SetPostSkipMusic("SND_MX_PRO_start_master")
    deerSpotBSeq:MarkAbleToSkip()
    deerSpotBSeq:SpawnActorAndWait(deerActor)
    deerSpotBSeq:RequestCineModeAndWait(kratosActor, thisObj)
    deerSpotBSeq:Do(StartCineEnter_DeerSpotB)
    deerSpotBSeq:ActorForceApproachAndWait(kratosActor, {
      Branch = "BRA_DeerSpotBCine",
      ReferenceJoint = "synchJointFront",
      speed = ND.KraWalkSpeed,
      stop = false,
      radius = 0.15,
      should_strafe = true,
      weapon_state = "bare"
    })
    deerSpotBSeq:ActorSync(kratosActor, {
      Slaves = deerSpotB_ActorTable,
      Branch = "BRA_DeerSpotBCine",
      ReferenceJoint = "synchJointFront"
    })
    deerSpotBSeq:Do(function()
      PlaySoundOnCine(doorObj)
    end)
    deerSpotBSeq:Do(_G.EnterTemple)
    deerSpotBSeq:Do(SyncExit)
    deerSpotBSeq:WaitForActorPuppeteerComplete(sonActor)
    deerSpotBSeq:StopPuppetingActor(sonActor)
    deerSpotBSeq:WaitForAndCompleteCineMode(kratosActor, thisObj)
    deerSpotBSeq:StopPuppetingActor(kratosActor)
    deerSpotBSeq:DespawnActor(deerActor)
    deerSpotBSeq:SetCompletedCineNumber(50)
    deerSpotBSeq:Do(function()
      game.World.StoreCheckpoint()
    end)
    deerSpotBSeq:StartSequence()
  end
end
function StartCineEnter_DeerSpotB()
  game.SubObject.Wake(thisObj)
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_DeerSpotB", 8)
  cameraCineEnter:SetCallback(DestroyCineEnter_DeerMiss)
  cameraCineEnter:Start()
end
function DestroyCineEnter_DeerMiss()
  cameraCineEnter = nil
  game.SubObject.Sleep(thisObj)
end
function SyncExit()
  game.FindLevel("For660_TempleInterior"):CallScript("CA_CineSyncExit")
end
function PlaySoundOnCine(doorSlaveObject)
  LD.PlaySoundOnFrame(doorSlaveObject:FindSingleSoundEmitterByName("SNDDoorLeft"), doorSlaveObject, "SND_DOOR_Stone_Double_Pry_Apart_Push_Close_L", 155, "forward")
  LD.PlaySoundOnFrame(doorSlaveObject:FindSingleSoundEmitterByName("SNDDoorRight"), doorSlaveObject, "SND_DOOR_Stone_Double_Pry_Apart_Push_Close_R", 155, "forward")
end
