local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local timers = require("level.timer")
local TUT = require("game.GlobalTutorials")
local monitors = require("level.MonitorLibrary")
local color = require("core.color")
local checkpoint = require("level.checkpoint")
local actor = require("narrative.actor")
local EC = require("design.Encounter")
local CCEC = require("camera.camera_cineentercamera")
local uiCalls = require("ui.uicalls")
local thisObj, thisLevel, player, for800_TrollArena
local playOnce = false
local trollHealthMonitor, buttonMonitor1
local arrowCounter = 0
local kraActor, sonActor, deerActor, trollActor, trollEnemy, miniGameObject
local trollFightActive = false
local trollAftermathB_Started = false
local btrShotReady = "290_ShotReady"
local cameraCineEnter, cameraCineEnterTrollSurprise, cine_lights_60, cine_lights_65, cine_lights_72
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
end
function OnStart()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 72 then
    if cineNum < 60 then
      local pos = GameObjects.Cine_DeerHit_Group:GetWorldJointPosition(GameObjects.Cine_DeerHit_Group:GetJointIndex("TrollSurprise_Troll_StartJoint"))
      game.Encounters.RequestGlobalCharacterPrestream(thisLevel, pos, "CRT_Troll00", "Troll00")
    end
    SetupActors()
    SetDeerSpawnFunction()
    SetTrollSpawnFunction()
    cine_lights_60 = GameObjects.Cine_Start_60
    cine_lights_65 = GameObjects.Cine_Start_65
    cine_lights_72 = GameObjects.Cine_Start_72
    HideCineLights_DeerHit()
    HideCineLights_TrollSurprise()
    HideCineLights_TrollAftermathB()
  end
  if trollFightActive == true then
    SetupActors()
    SetTrollSpawnFunction()
    SpawnTroll_ForRestoreCheckpoint()
  end
end
function OnUpdate(level, obj)
  if miniGameObject == nil then
    miniGameObject = level:FindSingleGameObject("DeerAimMiniGameA")
  end
  local cineNumber = game.Level.GetVariable("CompletedCineNumber")
  if 65 <= cineNumber and cineNumber < 72 and not playOnce and trollActor ~= nil and trollActor:GetCreature() ~= nil and (trollActor:GetCreature():IsPlayingMove("MOV_HitFinalStunEnter") or trollActor:GetCreature():IsPlayingMove("MOV_HitForestTrollStunEnter") or trollActor:GetCreature():IsPlayingMove("MOV_HitFinalStunLoop") or trollActor:GetCreature():IsPlayingMove("MOV_HitForestTrollStunLoop")) then
    uiCalls.UI_Event_TurnOffDesignerMessage()
    StopSon_TrollBehaviour()
    TUT.For800_Troll_Kill_Tutorial()
    playOnce = true
  end
  if 65 <= cineNumber and cineNumber < 72 and not trollAftermathB_Started and trollActor ~= nil and trollActor:GetCreature() ~= nil and (player:IsPlayingMove("MOV_RageGrabEnter") or player:IsPlayingMove("MOV_TrollAftermathB_Dummy")) then
    trollAftermathB_Started = true
    uiCalls.UI_Event_TurnOffDesignerMessage()
    TrollAftermathSequence()
  end
  if cameraCineEnter ~= nil then
    cameraCineEnter:Update()
  end
  if cameraCineEnterTrollSurprise ~= nil then
    cameraCineEnterTrollSurprise:Update()
  end
end
function OnSaveCheckpoint(level, obj)
  return {temp_trollFightActive = trollFightActive}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  trollFightActive = savedInfo.temp_trollFightActive
  if trollFightActive then
    SetupSonSequence()
  end
end
function SetDeerSpawnFunction()
  deerActor:SetSpawnFunction(function()
    return ND.SpawnAIAtJoint(thisLevel, "Cine_DeerHit_Group", "Deer_DeerHit_StartJoint", "CRT_Deer00", "BRA_DeerHitCineIdle", "deer")
  end)
end
function SetTrollSpawnFunction()
  trollActor:SetSpawnFunction(function()
    local spawnBranch
    if trollFightActive then
      spawnBranch = "BRA_Spawn"
    else
      spawnBranch = "BRA_TrollSurprise"
    end
    trollEnemy = ND.SpawnAIAtJoint(thisLevel, "Cine_DeerHit_Group", "TrollSurprise_Troll_StartJoint", "CRT_Troll00", spawnBranch, "troll", {PowerLevel = 1, TrollNoFire = true})
    trollEnemy:AddMarker("For800Troll")
    trollHealthMonitor = monitors.CreateHealthMonitor(trollEnemy)
    trollHealthMonitor:OnHealthLessThan(200, function()
      local son = game.AI.FindSon()
      son:AddMarker("RushTroll")
      son:AddMarker("SpecialVOMarker")
    end)
    trollHealthMonitor:OnHealthLessThan(70, function()
      game.Audio.PlayBanter("300_TrollAftermathA")
    end)
    return trollEnemy
  end)
end
function SpawnTroll_ForRestoreCheckpoint()
  local seq = LD.CreateCineSequence(thisLevel, thisObj, "spawn troll")
  seq:SpawnActorAndWait(trollActor)
  seq:Do(StartTutorials)
  seq:Do(function()
    if trollActor:GetCreature() ~= nil then
      local myTroll = trollActor:GetCreature()
      local myPlayer = game.Player.FindPlayer()
      local mySon = game.AI.FindSon()
      local playerPos = engine.Vector.New(-247.405, 44.619, -819.654)
      local trollPos = engine.Vector.New(-243.891, 44.654, -833.036)
      local sonPos = engine.Vector.New(-236.147, 44.796, -830.814)
      local playerFacing = (trollPos - playerPos):Normalized()
      local trollFacing = (playerPos - trollPos):Normalized()
      local sonFacing = (trollPos - sonPos):Normalized()
      myPlayer:Warp(playerPos, playerFacing)
      myTroll:Warp(trollPos, trollFacing)
      mySon:Warp(playerPos, playerFacing)
      timers.StartLevelTimer(0.1, function()
        game.Camera.Recenter({
          TimeStart = 0,
          TimeDuration = 1,
          YawRange = -1,
          RotationSpace = 1,
          TriggerLeft = 0,
          TriggerRight = 0,
          ReturnLeft = 0,
          ReturnRight = 0
        })
      end)
    end
  end)
  seq:StartSequence()
end
local DisableLeadTheWay = function()
  local for000_sky = game.FindLevel("For000_Sky")
  for000_sky:CallScript("DisableLeadTheWay")
end
local DisableYouShallNotPass = function()
  local for000_sky = game.FindLevel("For000_Sky")
  for000_sky:CallScript("DisableNoPass")
end
function SetupActors()
  kraActor = actor.Actor.New("DEER HIT: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("DEER Hit: Son Actor", game.AI.FindSon)
  deerActor = actor.Actor.New("DEER HIT: Deer Actor")
  trollActor = actor.Actor.New("TROLL SURPRISE: Troll Actor")
end
function cineNumber()
  return game.Level.GetVariable("CompletedCineNumber") >= 50 and game.Level.GetVariable("CompletedCineNumber") < 60
end
function DeerHitSequence()
  local deerHitSeq = LD.CreateCineSequence(thisLevel, thisObj, "Deer Spot B Sequence")
  local deerHit_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_DeerHitInteract"
    },
    {
      Actor = deerActor,
      Branch = "BRA_DeerHitInteract"
    }
  }
  deerHitSeq:WaitForFunctionTrue(cineNumber)
  deerHitSeq:SetPostSkipMusic("SND_MX_PRO_start_master", "SND_MX_PRO_deer_hit_lesson")
  deerHitSeq:ActorForceApproachAndWait(sonActor, {
    Branch = "BRA_DeerHitIdle",
    ReferenceJoint = "DeerHit_SynchJoint",
    speed = ND.SonRunSpeed,
    stop = false,
    foot = game.Creature.Foot.kRight,
    radius = ND.SonRunArrivalRadius,
    ignore_navmesh = true,
    completion_percentage = 0.75
  })
  deerHitSeq:ActorSync(sonActor, {
    Branch = "BRA_DeerHitIdle",
    ReferenceJoint = "DeerHit_SynchJoint"
  })
  deerHitSeq:WaitSeconds(1.5)
  deerHitSeq:Do(function()
    game.Audio.PlayBanter(btrShotReady)
  end)
  deerHitSeq:Do(function()
    local availabilityState = {Unoccupied = false}
    game.AI.FindSon():SetNewAvailabilityRequest("LevelDesignScript", availabilityState)
  end)
  deerHitSeq:WaitForActorInZone(kraActor, "CineZone_DeerHit")
  deerHitSeq:RequestCineModeAndWait(kraActor, thisObj)
  deerHitSeq:Do(StartCineEnter_DeerKill)
  deerHitSeq:Do(IncreaseKratosDeceleration)
  deerHitSeq:SpawnActorAndWait(deerActor)
  deerHitSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_DeerHitInteract",
    ReferenceJoint = "DeerHit_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius,
    weapon_state = "bare_on_back"
  })
  deerHitSeq:Do(function()
    deerHitSeq:MarkAbleToSkip()
  end)
  deerHitSeq:Do(DisableLeadTheWay)
  deerHitSeq:Do(DisableYouShallNotPass)
  deerHitSeq:Do(function()
    game.AI.FindSon():CallScript("LuaHook_ToggleSlowdownStops", true)
  end)
  deerHitSeq:Do(ClearKratosDeceleration)
  deerHitSeq:Do(PlayCineLights_DeerHit)
  deerHitSeq:Do(function()
    game.World.DisablePlayerStateSoftSave()
  end)
  deerHitSeq:ActorSync(kraActor, {
    Slaves = deerHit_ActorTable,
    Branch = "BRA_DeerHitInteract",
    ReferenceJoint = "DeerHit_SynchJoint"
  })
  deerHitSeq:Do(function()
    miniGameObject.LuaObjectScript.StartMiniGame(true)
  end)
  deerHitSeq:Do(function()
    GameObjects.CineZone_DeerHit:HideEntityVolume()
  end)
  deerHitSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_DeerInteractHitEnter") or kraActor:GetCreature():GetCurrentInteractObject() ~= thisObj
  end)
  deerHitSeq:WaitForFunctionTrue(function()
    return not player:IsPlayingMove("MOV_DeerInteractHitEnter") or kraActor:GetCreature():GetCurrentInteractObject() ~= thisObj
  end)
  deerHitSeq:Do(function()
    deerHitSeq:EndSkipIfActive()
  end)
  deerHitSeq:Do(function()
    uiCalls.UI_Event_Force_Reticle_Clear()
  end)
  deerHitSeq:Do(PauseCineLights_DeerHit)
  deerHitSeq:WaitForFunctionTrue(function()
    return player:IsPlayingMove("MOV_DeerInteractHitExit") or kraActor:GetCreature():GetCurrentInteractObject() ~= thisObj
  end)
  deerHitSeq:Do(function()
    miniGameObject.LuaObjectScript.StartMiniGame(false)
  end)
  deerHitSeq:Do(function()
    uiCalls.UI_Event_Force_Reticle_Off()
  end)
  deerHitSeq:Do(function()
    game.SubmitActivityFeedStory("01_DeerKill")
  end)
  deerHitSeq:Do(ResumeCineLights_DeerHit)
  deerHitSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  deerHitSeq:StopPuppetingActor(kraActor)
  deerHitSeq:Do(HideCineLights_DeerHit)
  deerHitSeq:Do(HideDeerHitZone)
  deerHitSeq:Do(function()
    game.FindLevel("For000_Sky"):GetGameObject("InputMask"):CallScript("AxtTut_Step_0")
  end)
  deerHitSeq:SetCompletedCineNumber(60)
  deerHitSeq:WaitForActorMoveComplete(sonActor, thisObj)
  deerHitSeq:Do(function()
    game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
  end)
  deerHitSeq:StartSequence()
end
function HideDeerHitZone()
  GameObjects.CineZone_DeerHit:HideEntityVolume()
end
function PlayCineLights_DeerHit()
  cine_lights_60:Show()
  cine_lights_60:JumpAnimToFrame(0)
  cine_lights_60:PlayAnimToEnd()
end
function HideCineLights_DeerHit()
  cine_lights_60:Hide()
end
function PauseCineLights_DeerHit()
  cine_lights_60:JumpAnimToFrame(300)
  cine_lights_60:PauseAnimation()
end
function ResumeCineLights_DeerHit()
  cine_lights_60:PlayAnimToEnd()
end
function SetSonAsAvailable()
  game.AI.FindSon():RemoveAvailabilityRequest("LevelDesignScript")
end
function TrollSurpriseSequence()
  local cineSeq = LD.CreateCineSequence(thisLevel, thisObj, "Troll Surprise Sequence")
  local trollSurprise_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_TrollSurprise"
    },
    {
      Actor = deerActor,
      Branch = "BRA_TrollSurprise"
    },
    {
      Actor = trollActor,
      Branch = "BRA_TrollSurprise"
    }
  }
  cineSeq:SetPostSkipMusic("SND_MX_PRO_start_master", nil, nil, nil, nil, "SND_MX_PRO_troll_fight_in")
  cineSeq:MarkAbleToSkip()
  cineSeq:RequestCineModeAndWait(kraActor, thisObj)
  cineSeq:Do(IncreaseKratosDeceleration)
  cineSeq:Do(StartCineEnter_TrollSurprise)
  cineSeq:SpawnActorAndWait(trollActor)
  cineSeq:SpawnActorAndWait(deerActor)
  cineSeq:ActorForceApproachAndWait(kraActor, {
    Branch = "BRA_TrollSurprise",
    ReferenceJoint = "TrollSurprise_SynchJoint",
    speed = ND.KraWalkSpeed,
    stop = false,
    foot = game.Creature.Foot.kLeft,
    radius = ND.ArrivalRadius,
    weapon_state = "bare_on_back",
    strafe_distance = 1.5,
    ignore_navmesh = false
  })
  cineSeq:Do(PlayCineLights_TrollSurprise)
  cineSeq:Do(ClearKratosDeceleration)
  cineSeq:Do(function()
    game.FindLevel("For800_TrollArena"):CallScript("PlayPillarBreakAnim")
    game.Combat.TurnOnAndLockCombatStatus()
  end)
  cineSeq:ActorSync(kraActor, {
    Slaves = trollSurprise_ActorTable,
    Branch = "BRA_TrollSurprise",
    ReferenceJoint = "TrollSurprise_SynchJoint"
  })
  cineSeq:WaitUntilActorAnimPastFrame(kraActor, 2885)
  cineSeq:Do(function()
    cineSeq:EndSkipIfActive()
  end)
  cineSeq:Do(CompleteObjFor200)
  cineSeq:Do(DisableCharacterMovements)
  cineSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  cineSeq:Do(SetSonAsAvailable)
  cineSeq:Do(DisableYouShallNotPass)
  cineSeq:Do(function()
    trollFightActive = true
  end)
  cineSeq:SetCompletedCineNumber(65)
  cineSeq:Do(HideCineLights_TrollSurprise)
  cineSeq:Do(StartArrowTutorial)
  cineSeq:Do(EmptyInputMask)
  cineSeq:StopPuppetingActor(deerActor)
  cineSeq:DespawnActor(deerActor)
  cineSeq:StopPuppetingActor(kraActor)
  cineSeq:WaitForActorMoveComplete(sonActor)
  cineSeq:StopPuppetingActor(sonActor)
  cineSeq:WaitForActorMoveComplete(trollActor)
  cineSeq:StopPuppetingActor(trollActor)
  cineSeq:Do(ClearPrestreamData)
  cineSeq:StartSequence()
end
function StartTutorials()
  timers.StartLevelTimer(5.5, SetSonBasicArrow)
  timers.StartLevelTimer(23, function()
    if not playOnce then
      TUT.DodgeRoll_Tutorial()
    end
  end)
  timers.StartLevelTimer(45, function()
    if not playOnce then
      TUT.BossHealth_Tutorial()
      StartArrowMonitor()
    end
  end)
  timers.StartLevelTimer(70, CheckArrowUse)
  SetupSonSequence()
end
function StartArrowMonitor()
  buttonMonitor1 = monitors.CreateSquareButtonMonitor()
  buttonMonitor1:OnButtonDown(ArrowButtonUsed)
end
function ArrowButtonUsed()
  arrowCounter = arrowCounter + 1
end
function CheckArrowUse()
  if arrowCounter < 18 and not playOnce then
    TUT.FireSonArrow_Tutorial()
  end
end
function PlayCineLights_TrollSurprise()
  cine_lights_65:Show()
  cine_lights_65:JumpAnimToFrame(0)
  cine_lights_65:PlayAnimToEnd()
end
function HideCineLights_TrollSurprise()
  cine_lights_65:Hide()
end
function EmptyInputMask()
  game.FindLevel("For000_Sky"):GetGameObject("InputMask"):CallScript("ClearInputMask")
end
function ClearPrestreamData()
  game.Encounters.ClearGlobalCharacterPrestreamRequest()
end
function TrollAftermathSequence()
  local trollAftermathBSeq = LD.CreateCineSequence(thisLevel, thisObj, "Troll Aftermath B Sequence")
  if trollActor:GetCreature() == nil then
    trollActor = actor.Actor.New("TROLL AFTERMATH B: Troll Actor", FindTroll)
  end
  local trollAftermathBEnter_ActorTable = {
    {
      Actor = sonActor,
      Branch = "BRA_TrollAftermathB",
      StartTime = 6.0275
    },
    {
      Actor = trollActor,
      Branch = "BRA_TrollAftermathB"
    }
  }
  trollAftermathBSeq:SetPostSkipMusic("SND_MX_PRO_start_master")
  trollAftermathBSeq:MarkAbleToSkip()
  trollAftermathBSeq:WaitForActorPlayingMove(kraActor, "MOV_TrollAftermathB_Dummy")
  trollAftermathBSeq:WaitUntilActorAnimPastPercentage(kraActor, 0.074)
  trollAftermathBSeq:RequestCineModeAndWait(kraActor, thisObj)
  trollAftermathBSeq:Do(PlayCineLights_TrollAftermathB)
  trollAftermathBSeq:ActorSync(kraActor, {
    Slaves = trollAftermathBEnter_ActorTable,
    Branch = "BRA_TrollAftermathB",
    ReferenceJoint = "TEMP_SynchJoint",
    ReferenceJointOn = 0.08,
    ReferenceJointTweenTime = 0.68
  })
  trollAftermathBSeq:Do(function()
    LD.DisableCombatBanter()
  end)
  trollAftermathBSeq:Do(function()
    game.AI.FindSon():CallScript("EnterBehaviorContext", "FRUSTRATED_CONTEXT_CONFIG")
  end)
  trollAftermathBSeq:Do(function()
    game.FindLevel("For800_TrollArena"):CallScript("RevealExit")
  end)
  trollAftermathBSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
  trollAftermathBSeq:Do(function()
    trollAftermathBSeq:EndSkipIfActive()
  end)
  trollAftermathBSeq:WaitForActorMoveComplete(kraActor)
  trollAftermathBSeq:StopPuppetingActor(kraActor)
  trollAftermathBSeq:SetCompletedCineNumber(72)
  trollAftermathBSeq:StopPuppetingActor(sonActor)
  trollAftermathBSeq:Do(HideCineLights_TrollAftermathB)
  trollAftermathBSeq:Do(function()
    LD.CallFunctionAfterDelay(TrollAftermathDone, 0.25)
  end)
  trollAftermathBSeq:Do(function()
    LD.EnableContextBehaviorBanter()
  end)
  trollAftermathBSeq:WaitForActorMoveComplete(trollActor)
  trollAftermathBSeq:DespawnActor(trollActor)
  trollAftermathBSeq:Do(function()
    game.World.StoreCheckpoint()
  end)
  trollAftermathBSeq:StartSequence()
end
function FindTroll()
  local objArray = game.World.FindGameObjectsByMarker("For800Troll")
  for _, obj in ipairs(objArray) do
    if obj:GetCreature() ~= nil and obj:GetCreature():GetAI() ~= nil then
      return obj:GetCreature():GetAI()
    end
  end
  return nil
end
function StopSon_TrollBehaviour()
  game.AI.FindSon():RemoveMarker("FirstTrollBehavior")
  game.AI.FindSon():RemoveMarker("RushTroll")
  game.AI.FindSon():RemoveMarker("ArrowTutorial")
  game.AI.FindSon():RemoveMarker("SpecialVOMarker")
  game.Combat.UnlockCombatStatus()
end
function PlayCineLights_TrollAftermathB()
  cine_lights_72:Show()
  cine_lights_72:JumpAnimToFrame(0)
  cine_lights_72:PlayAnimToEnd()
end
function HideCineLights_TrollAftermathB()
  cine_lights_72:Hide()
end
function TrollAftermathDone()
  LD.CompleteQuest("Quest_Forest_Objective700")
  trollFightActive = false
  LD.UnlockBestiaryEntry("Bestiary_Unlock_Troll_Daudi_Kaupmadr")
  LD.ActivateQuest("Quest_Labor_TrollKills_Parent")
  game.QuestManager.IncrementQuestProgress("Quest_Labor_TrollKills_Bronze", 1)
  game.QuestManager.IncrementQuestProgress("Quest_Labor_TrollKills_Silver", 1)
  game.QuestManager.IncrementQuestProgress("Quest_Labor_TrollKills", 1)
  game.QuestManager.IncrementQuestProgress("Quest_Labor_EnemyKills_Bronze", 1)
  game.QuestManager.IncrementQuestProgress("Quest_Labor_EnemyKills_Silver", 1)
  game.QuestManager.IncrementQuestProgress("Quest_Labor_EnemyKills", 1)
  LD.CallFunctionAfterDelay(function()
    game.Audio.PlayBanter("310_LastWord")
  end, 1)
  game.World.StoreCheckpoint()
end
function SetupSonSequence()
  local son = game.AI.FindSon()
  son:AddMarker("FirstTrollBehavior")
  timers.StartLevelTimer(14, function()
    son:AddMarker("RushTroll")
  end)
  timers.StartLevelTimer(34, function()
    son:RemoveMarker("ArrowTutorial")
  end)
end
function SetSonBasicArrow()
  game.Audio.PlayBanter("295_FirstCommand", TUT.FireSonArrow_Tutorial)
end
function DisableCharacterMovements()
  game.AI.FindSon():SetMaxSpeedOverride(0)
  local pad = game.Player.FindPlayer().Pad
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:DisableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickX)
  pad:DisableGameButton(tweaks.ePad.kPadRightStickY)
end
function StartArrowTutorial()
  TUT.ArrowCooldown_Tutorial()
end
function ArrowAcquireTutComplete()
  StartTutorials()
  game.AI.FindSon():ClearMaxSpeedOverride()
  local pad = game.Player.FindPlayer().Pad
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickX)
  pad:EnableGameButton(tweaks.ePad.kPadLeftStickY)
  pad:EnableGameButton(tweaks.ePad.kPadRightStickX)
  pad:EnableGameButton(tweaks.ePad.kPadRightStickY)
  game.World.EnablePlayerStateSoftSave()
  game.World.StoreCheckpoint()
  trollEnemy:TriggerMoveEvent("kLE_Taunt04")
  if game.FindLevel("For800_TrollArena") ~= nil then
    game.FindLevel("For800_TrollArena"):CallScript("EnableCombatCA")
  end
  if game.GetNewGamePlus() then
    engine.SendHook("OnCommandSonStart", game.AI.FindSon(), "SwitchArrow")
    game.AI.FindSon():RequestHighPriorityUpdate()
  end
end
function StartCineEnter_DeerKill()
  cameraCineEnter = CCEC.CineEnterCamera.New("ENV_CineEnter_DeerKillIntro", 12)
  cameraCineEnter:SetCallback(DestroyCineEnter_DeerKill)
  cameraCineEnter:Start()
end
function DestroyCineEnter_DeerKill()
  cameraCineEnter = nil
end
function StartCineEnter_TrollSurprise()
  cameraCineEnterTrollSurprise = CCEC.CineEnterCamera.New("ENV_CineEnter_narForTrollSurprise010CineScene", 12)
  cameraCineEnterTrollSurprise:SetCallback(DestroyCineEnterTrollSurprse)
  cameraCineEnterTrollSurprise:Start()
end
function DestroyCineEnterTrollSurprse()
  cameraCineEnterTrollSurprise = nil
end
function CompleteObjFor200()
  LD.CompleteQuest("Quest_Forest_Objective200")
end
function IncreaseKratosDeceleration()
  game.Player.FindPlayer():SetDecelerationOverride(1.2)
  game.Player.FindPlayer():SetAccelerationOverride(1.2)
end
function ClearKratosDeceleration()
  game.Player.FindPlayer():ClearDecelerationOverride()
  game.Player.FindPlayer():ClearAccelerationOverride()
end
