local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local uiCalls = require("ui.uicalls")
local EC = require("design.Encounter")
local checkpoint = require("level.checkpoint")
local TUT = require("game.GlobalTutorials")
local thisLevel, son
local sonHit = 0
local BoostStartZone, zoneMonitor2, ProgressMonitor
local exitRevealed = false
local dropEnabled = false
local ResourceCheckTimer
local trollFightComplete = false
local followUpFightComplete = false
local Area_1_Encounter_1, Draugr_HealthMonitor
function OnScriptLoaded(level)
  thisLevel = level
  son = game.AI.FindSon()
  Intro_Draugr_Shield_Fight_1()
end
function OnStart(level)
  HideBoostHintZone()
  HideTrollLoot()
  if Area_1_Encounter_1:WasRunning() then
    Area_1_Encounter_1:Start()
  end
  if game.Level.GetVariable("CompletedCineNumber") < 100 then
    GameObjects.GeneralGuide_State1:ShowCollision()
    GameObjects.GeneralGuide_State2:HideCollision()
    GameObjects.SCRIPTED_ROCKS:HideCollision()
    GameObjects.SCRIPTED_ROCKS:Hide()
    GameObjects.SCRIPTED_Traverse:HideTraverseLink()
    GameObjects.EntZn_EnableSonDropZone:HideEntityVolume()
    GameObjects.TraversePath2:HideTraversePath()
  else
    GameObjects.ca_BoostDropDown.LuaObjectScript.Disable()
    dropEnabled = false
    GameObjects.GeneralGuide_State2:ShowCollision()
    GameObjects.GeneralGuide_State1:HideCollision()
    GameObjects.SCRIPTED_ROCKS:ShowCollision()
    GameObjects.SCRIPTED_ROCKS:Show()
    GameObjects.SCRIPTED_Traverse:ShowTraverseLink()
    GameObjects.EntZn_EnableSonDropZone:ShowEntityVolume()
    GameObjects.TraversePath2:ShowTraversePath()
  end
  GameObjects.EntZn_StartSonDrop:HideEntityVolume()
end
function OnFirstStart()
  GameObjects.TravLink_Boost:HideTraverseLink()
  GameObjects.TraversePath_Boost:HideTraversePath()
end
function OnUpdate(level)
  if dropEnabled == true then
    local yDistance = GameObjects.ca_BoostDropDown.WorldPosition.y - son.WorldPosition.y
    if 2 < yDistance then
      GameObjects.ca_BoostDropDown.LuaObjectScript.Disable()
      dropEnabled = false
    end
  end
end
function OnSaveCheckpoint(level)
  return {
    levelstate = checkpoint.Save(),
    trollFightComplete = trollFightComplete
  }
end
function OnRestoreCheckpoint(level, savedInfo)
  checkpoint.Restore(savedInfo.levelstate)
  trollFightComplete = savedInfo.trollFightComplete
end
function PlayPillarBreakAnim()
  GameObjects.troll_surprise_pillar_break.Child:PlayAnimToEnd()
end
function BossFightStart()
end
function EnableCombatCA()
  GameObjects.CA_CombatTrollIntro.LuaObjectScript.Enable()
end
function RevealExit()
  if exitRevealed == false then
    LD.SetEntityVariable("FOR_BaldurIntroEnabled", true)
    exitRevealed = true
    game.Audio.StartMusic("SND_MX_PRO_troll_outro")
    GameObjects.CA_Idle_NearExit.LuaObjectScript.Enable()
    trollFightComplete = true
    EnableBoostExit()
  end
end
function HasBlockBreak()
  return game.Wallets.GetResourceValue("HERO", "Axe_Tier01_BlockBreak") >= 1
end
function ShowBoostHint()
  TUT.BoostSon_Tutorial()
end
function RemoveBoostHint()
  uiCalls.UI_Event_TurnOffDesignerMessage()
end
function HideBoostHintZone()
  GameObjects.entityZone_BoostHint:HideEntityVolume()
end
function SwitchBoost()
  GameObjects.TravLink_Boost:ShowTraverseLink()
  GameObjects.TraversePath_Boost:HideTraversePath()
  game.FindLevel("For810_TrollArenaExit"):CallScript("EnableLTW")
  game.FindLevel("For810_TrollArenaExit"):CallScript("EnableSyncExit")
end
function TurnOnSonDropZone()
  GameObjects.EntZn_StartSonDrop:ShowEntityVolume()
end
function StartSonDropDown()
  GameObjects.EntZn_StartSonDrop:HideEntityVolume()
  GameObjects.ca_syncexithelper.LuaObjectScript.Disable()
  GameObjects.ca_BoostDropDown.LuaObjectScript.Enable()
  dropEnabled = true
end
function Intro_Draugr_Shield_Fight_1()
  Area_1_Encounter_1 = EC.NewEncounter(thisLevel, "[Area 1]EC:1 Shield Intro", {CheckpointOnComplete = true})
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_SH_SPA",
      markerID = "Draugr_Shield_Intro",
      spawnLocators = "Loc_A_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:AddWave({
    {
      spawners = "Draugr_SH_SPA",
      spawnLocators = "Loc_A_01",
      useSpawnLocatorsOnly = true,
      maxActive = 1,
      totalSpawns = 1,
      spawnCooldown = 0
    }
  })
  Area_1_Encounter_1:OnEnemySpawn(Draugr_Health_Encounter, {
    markerID = "Draugr_Shield_Intro"
  })
  Area_1_Encounter_1:OnComplete(EnableBoostExit)
end
function EnableBoostExit()
  uiCalls.UI_Event_TurnOffDesignerMessage()
  GameObjects.TraversePath_Boost:ShowTraversePath()
  GameObjects.entityZone_BoostHint:ShowEntityVolume()
end
local Draugr_Next = function()
  Area_1_Encounter_1:StartWave(2)
end
function Draugr_Health_Encounter(Enemy)
  if Enemy ~= nil then
    local Draugr_Health = Enemy:GetHitPoints()
    Draugr_HealthMonitor = monitors.CreateHealthMonitor(Enemy)
    local Health_Phase_1 = Draugr_Health * 0.5
    Draugr_HealthMonitor:OnHealthLessThan(Health_Phase_1, Draugr_Next)
  end
end
function Btr_SonHit()
  sonHit = sonHit + 1
  if sonHit == 1 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("300_TrollAftermathA_3")
    end, 0.5)
  elseif sonHit == 2 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("300_TrollAftermathA_1")
    end, 0.75)
  elseif sonHit == 3 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("300_TrollAftermathA_5")
    end, 1.25)
  elseif sonHit == 4 then
    LD.CallFunctionAfterDelay(function()
      game.Audio.PlayBanter("300_TrollAftermathA_7")
    end, 1)
  end
end
function ShowTrollLoot()
  GameObjects.corpse_rare_tier5_for800_1.LuaObjectScript.Enable()
  GameObjects.TrollLoot_HealthRune_Small1.LuaObjectScript.Enable()
  GameObjects.TrollLoot_HealthRune_Small2.LuaObjectScript.Enable()
  local trollLoot = thisLevel:FindSingleGameObject("corpse_rare_tier5_for800_1")
  trollLoot:Show()
end
function HideTrollLoot()
  GameObjects.corpse_rare_tier5_for800_1.LuaObjectScript.Disable()
  GameObjects.TrollLoot_HealthRune_Small1.LuaObjectScript.Disable()
  GameObjects.TrollLoot_HealthRune_Small2.LuaObjectScript.Disable()
  local trollLoot = thisLevel:FindSingleGameObject("corpse_rare_tier5_for800_1")
  trollLoot:Hide()
end
