function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnBreakableBroken(level, obj)
  if string.match(obj:GetName(), "base_break") then
    obj.Parent.LuaObjectScript.BreakWhole()
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_GIANT",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.1},
      Priority = 5
    })
    game.Blender.Trigger({
      Name = "FFB_GENERIC_RUMBLE_MEDIUM",
      Duration = 0.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 2},
      Priority = 5
    })
  else
    game.Blender.Trigger({
      Name = "FSE_SHAKE_GENERIC_SMALL",
      Duration = 1.5,
      TweenIn = {Time = 0},
      TweenOut = {Time = 0.1}
    })
    obj.Parent.LuaObjectScript.BreakPiece()
  end
end
