local LD = require("design.LevelDesignLibrary")
function OnStart(level)
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if 100 < cineNum then
    GameObjects.SCRIPTED_TV810_Retraverse:Show()
    GameObjects.EntZn_ShallNoPass_Enable:HideEntityVolume()
    GameObjects.LTW_WayHome1.LuaObjectScript.Disable()
    GameObjects.LTW_WayHome_Follow.LuaObjectScript.Enable()
    GameObjects.CA_Idle_AfterBoost.LuaObjectScript.Disable()
  else
    GameObjects.SCRIPTED_TV810_Retraverse:Hide()
  end
end
function OnSaveCheckpoint(level)
  return {}
end
function OnRestoreCheckpoint(level, savedInfo)
end
function DisableShallNotPass()
  GameObjects.TrollExit_NoPass.LuaObjectScript.Disable()
end
function EnableLTW()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 100 then
    GameObjects.LTW_WayHome1.LuaObjectScript.Enable()
  else
    GameObjects.LTW_WayHome_Follow.LuaObjectScript.Enable()
  end
end
function EnableSyncExit()
  GameObjects.CA_Idle_AfterBoost.LuaObjectScript.Enable()
end
function DisableSlowDown()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 100 then
    game.AI.FindSon():CallScript("LuaHook_ToggleSlowdownStops", false)
  end
end
function Enable_SlowDown()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 100 then
    game.AI.FindSon():CallScript("LuaHook_ToggleSlowdownStops", true)
  end
end
function OnEvaluateLoadGroup_Cinematic()
  local cineNum = game.Level.GetVariable("CompletedCineNumber")
  if cineNum < 100 then
    return "Baldur"
  else
    return "EndGame"
  end
end
