local LD = require("design.LevelDesignLibrary")
local ND = require("design.NarrativeDesignLibrary")
local actor = require("narrative.actor")
local checkpoint = require("level.checkpoint")
local thisObj, thisLevel, player, kraActor, sonActor
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  InitializeVariables()
end
function OnUpdate(level, obj)
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {
    LevelState = checkpoint.Save()
  }
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  checkpoint.Restore(savedInfo.LevelState)
end
function InitializeVariables()
  if game.Level.GetVariable("CompletedCineNumber") < 110 then
    SetupActors()
  end
end
function SetupActors()
  kraActor = actor.Actor.New("RUNIC STAVE: Kratos Actor", game.Player.FindPlayer)
  sonActor = actor.Actor.New("RUNIC STAVE: Son Actor", game.AI.FindSon)
end
function cineNumber()
  return
end
function RunicStaveSequence()
  if game.Level.GetVariable("CompletedCineNumber") < 110 then
    local runicStaveSeq = LD.CreateCineSequence(thisLevel, thisObj, "Runic Stave Sequence")
    local runicStaveEnter_ActorTable = {
      {
        Actor = sonActor,
        Branch = "BRA_RunicStave"
      }
    }
    runicStaveSeq:SetPostSkipMusic("SND_MX_PRO_start_master")
    runicStaveSeq:Do(AddApproachMarker)
    runicStaveSeq:RequestCineModeAndWait(kraActor, thisObj)
    runicStaveSeq:WaitForFunctionTrue(function()
      return player:IsPlayingMove("MOV_Crack_Climb_Up_Exit")
    end)
    runicStaveSeq:Do(function()
      runicStaveSeq:MarkAbleToSkip()
    end)
    runicStaveSeq:ActorSync(kraActor, {
      Slaves = runicStaveEnter_ActorTable,
      Branch = "BRA_RunicStave",
      ReferenceJoint = "RunicStave_SynchJoint"
    })
    runicStaveSeq:WaitForAndCompleteCineMode(kraActor, thisObj)
    runicStaveSeq:Do(RemoveApproachMarker)
    runicStaveSeq:StopPuppetingActor(kraActor)
    runicStaveSeq:StopPuppetingActor(sonActor)
    runicStaveSeq:Do(EnableContextActions)
    runicStaveSeq:SetCompletedCineNumber(110)
    runicStaveSeq:Do(HideCineTriggerZone)
    runicStaveSeq:Do(function()
      local bookmarks = require("design.Bookmarks")
      local tableEntry = bookmarks["BOOKMARK_" .. "01_Forest_080_Leave"]
      game.World.StoreCheckpointAndBookmark(tableEntry)
    end)
    runicStaveSeq:StartSequence()
  end
end
function AddApproachMarker()
  if not player:HasMarker("ApproachingCine") then
    player:AddMarker("ApproachingCine")
  end
end
function RemoveApproachMarker()
  if player:HasMarker("ApproachingCine") then
    player:RemoveMarker("ApproachingCine")
  end
end
function HideCineTriggerZone()
  GameObjects.Cine_RunicStave:Hide()
end
function EnableContextActions()
  LD.EnableContextBehaviorBanter()
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_ObserveFar_01.LuaObjectScript.Enable()
  end, 1)
  LD.CallFunctionAfterDelay(function()
    GameObjects.CA_IdleBehavior_01.LuaObjectScript.Enable()
  end, 2)
end
