local luaTable
local Type = {
  Ground = 0,
  Air = 1,
  Strafe = 2
}
function OnScriptLoaded(level, obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  luaTable = {
    fleeDistance = obj:GetLuaTableAttribute("FleeDistance"),
    respawnTime = obj:GetLuaTableAttribute("RespawnTime"),
    curve = obj:GetLuaTableAttribute("Curve"),
    speed = obj:GetLuaTableAttribute("Speed"),
    bankLimit = math.rad(obj:GetLuaTableAttribute("BankLimit")),
    static = obj:GetLuaTableAttribute("Static"),
    fadeStart = 75,
    fadeEnd = 100
  }
  local character = obj:GetLuaTableAttribute("Character")
  local underscore = string.find(character, "_")
  if underscore then
    luaTable.character = string.sub(character, 1, underscore - 1)
    luaTable.spawnMove = "MOV" .. string.sub(character, underscore, string.len(character))
  else
    luaTable.character = character
    luaTable.spawnMove = obj.SpawnWildlife and "MOV_Idle" or "MOV_Spawn"
  end
  if luaTable.character == "Fish00" and 1 < math.random(4) then
    luaTable.character = "Fish10"
  end
  if luaTable.speed == 0 then
    if luaTable.character == "Crow00" then
      luaTable.speed = 8
    elseif luaTable.character == "Seagull00" then
      luaTable.speed = 8
    elseif luaTable.character == "Squirrel00" then
      luaTable.speed = 6
    elseif luaTable.character == "Rat00" then
      luaTable.speed = 6
    elseif luaTable.character == "Frog00" then
      luaTable.speed = 4.625
    elseif luaTable.character == "Salamander00" then
      luaTable.speed = 0.53
    end
  end
  luaTable.acceleration = 0
  luaTable.startIdle = true
  if luaTable.character == "Crow00" then
    luaTable.acceleration = 12
    if luaTable.spawnMove == "MOV_Fly" then
      luaTable.startIdle = false
    end
    luaTable.type = Type.Air
  elseif luaTable.character == "Seagull00" then
    luaTable.acceleration = 12
    if luaTable.spawnMove == "MOV_Fly" then
      luaTable.startIdle = false
    end
    luaTable.type = Type.Air
  elseif luaTable.character == "Squirrel00" then
    luaTable.acceleration = 20
    luaTable.type = Type.Ground
  elseif luaTable.character == "Rat00" then
    luaTable.acceleration = 20
    luaTable.type = Type.Ground
  elseif luaTable.character == "Frog00" then
    luaTable.acceleration = 100
    luaTable.type = Type.Ground
  elseif luaTable.character == "Salamander00" then
    luaTable.acceleration = 5
    luaTable.type = Type.Ground
  elseif luaTable.character == "Fish00" then
    luaTable.speed = 0
    luaTable.respawnTime = 0
    luaTable.startIdle = false
    luaTable.type = Type.Ground
  elseif luaTable.character == "Fish10" then
    luaTable.speed = 0
    luaTable.respawnTime = 0
    luaTable.startIdle = false
    luaTable.type = Type.Ground
  end
end
function OnStart(level, obj)
  obj:SpawnWildlife({
    FleeDistance = luaTable.fleeDistance,
    RespawnTime = luaTable.respawnTime,
    Speed = luaTable.speed,
    Acceleration = luaTable.acceleration,
    BankLimit = luaTable.bankLimit,
    StartIdle = luaTable.startIdle,
    RandomStartPos = true,
    Character = luaTable.character,
    Curve = luaTable.curve,
    SpawnMove = luaTable.spawnMove,
    Type = luaTable.type
  })
  game.SubObject.Sleep(obj)
end
