local LD = require("design.LevelDesignLibrary")
local thisObj, player
local enabled = true
local zoomAngle, strafeAngle, maxZoomRadius, maxStrafeRadius, toolboxEmbedCallbacks, toolboxUnembedCallbacks, toolboxUnembedStartCallbacks, toolboxLockedOnCallbacks, toolboxOnHitCallbacks, toolboxOnPassedThroughCallbacks, toolboxOnWeaponIncomingCallbacks, embedCallbacks, unembedCallbacks, unembedStartCallbacks, onHitCallbacks, passedThroughCallbacks, singleUse, passThrough, usesMultiCollision, assistTarget
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  enabled = obj:GetLuaTableAttribute("TargetingEnabled")
  zoomAngle = obj:GetLuaTableAttribute("ZoomAngle")
  strafeAngle = obj:GetLuaTableAttribute("StrafeAngle")
  maxZoomRadius = obj:GetLuaTableAttribute("MaxZoomRadius")
  maxStrafeRadius = obj:GetLuaTableAttribute("MaxStrafeRadius")
  singleUse = obj:GetLuaTableAttribute("SingleUse")
  passThrough = obj:GetLuaTableAttribute("PassThrough")
  usesMultiCollision = obj:FindLuaTableAttribute("usesMultiCollision")
  toolboxEmbedCallbacks = obj:FindLuaTableAttribute("OnWeaponEmbed")
  toolboxUnembedCallbacks = obj:FindLuaTableAttribute("OnWeaponUnembed")
  toolboxUnembedStartCallbacks = obj:FindLuaTableAttribute("OnWeaponUnembedStart")
  toolboxLockedOnCallbacks = obj:FindLuaTableAttribute("OnWeaponLockedOn")
  toolboxOnHitCallbacks = obj:FindLuaTableAttribute("OnWeaponHit")
  toolboxOnPassedThroughCallbacks = obj:FindLuaTableAttribute("OnWeaponPassedThrough")
  toolboxOnWeaponIncomingCallbacks = obj:FindLuaTableAttribute("OnWeaponIncoming")
  toolboxEmbedCallbacks = LD.ExtractCallbacksForEvent(level, obj, toolboxEmbedCallbacks)
  toolboxUnembedCallbacks = LD.ExtractCallbacksForEvent(level, obj, toolboxUnembedCallbacks)
  toolboxUnembedStartCallbacks = LD.ExtractCallbacksForEvent(level, obj, toolboxUnembedStartCallbacks)
  toolboxLockedOnCallbacks = LD.ExtractCallbacksForEvent(level, obj, toolboxLockedOnCallbacks)
  toolboxOnHitCallbacks = LD.ExtractCallbacksForEvent(level, obj, toolboxOnHitCallbacks)
  toolboxOnPassedThroughCallbacks = LD.ExtractCallbacksForEvent(level, obj, toolboxOnPassedThroughCallbacks)
  toolboxOnWeaponIncomingCallbacks = LD.ExtractCallbacksForEvent(level, obj, toolboxOnWeaponIncomingCallbacks)
  obj:HideModel()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
  if enabled then
    Enable()
  else
    Disable()
  end
end
function OnWeaponEmbed(level, go, attacker, weapon)
  if enabled and weapon:GetName() == "axe00" then
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxEmbedCallbacks, "WeaponEmbeddedEvents")
    FireEmbedCallbacks()
  end
  Disable()
end
function OnTargetPassedThrough(level, go, attacker, weapon)
  if enabled and player.Axe.ThrowOutStatus == tweaks.tThrowOutStatus.eThrownWeaponStatus.kTOSInFlightOut and weapon:GetName() == "axe00" then
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxOnPassedThroughCallbacks, "WeaponPassedThroughEvents")
    FireEmbedCallbacks()
  end
end
function OnWeaponIncoming(level, go, attacker, weapon)
  if enabled and weapon:GetName() == "axe00" then
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxOnWeaponIncomingCallbacks, "WeaponLockedOnEvents")
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxLockedOnCallbacks, "WeaponIncomingEvents")
  end
end
function OnWeaponUnembed(level, go, attacker, weapon)
  if weapon:GetName() == "axe00" then
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxUnembedCallbacks, "WeaponUnembededEvents")
    FireUnembedCallbacks()
  end
  if singleUse == false then
    Enable()
  end
end
function OnWeaponUnembedStart(level, go, attacker, weapon)
  if enabled == true then
    FireUnembedStartCallbacks()
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxUnembedStartCallbacks, "WeaponUnembedStartEvents")
  end
end
function OnWeaponLockedOn(level, go, attacker, weapon)
  if enabled then
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxLockedOnCallbacks, "WeaponLockedOnEvents")
  end
end
function OnHitByWeapon(level, obj, weapon, weaponOwnerCreature)
  if enabled and weapon:GetName() == "axe00" then
    LD.ExecuteCallbacksForEvent(level, thisObj, toolboxOnHitCallbacks, "WeaponHitEvents")
    FireHitCallbacks()
  end
end
function Enable()
  enabled = true
  if assistTarget ~= nil then
    return
  end
  local passThroughJoint
  if passThrough == false then
    passThroughJoint = 0
  else
    passThroughJoint = 1
  end
  assistTarget = LD.AddAxeTarget(thisObj, "AxeJoint", zoomAngle, maxZoomRadius, strafeAngle, maxStrafeRadius, passThroughJoint)
  if usesMultiCollision then
    thisObj:HideJoint(thisObj:GetJointIndex("disabledCollision"))
    thisObj:ShowJoint(thisObj:GetJointIndex("enabledCollision"))
  end
end
function Disable()
  enabled = false
  if assistTarget == nil then
    return
  end
  local passThroughJoint
  if passThrough == false then
    passThroughJoint = 0
  else
    passThroughJoint = 1
  end
  LD.RemoveAxeTarget(thisObj, "AxeJoint", zoomAngle, maxZoomRadius, strafeAngle, maxStrafeRadius, passThroughJoint)
  assistTarget = nil
  if usesMultiCollision then
    thisObj:ShowJoint(thisObj:GetJointIndex("disabledCollision"))
    thisObj:HideJoint(thisObj:GetJointIndex("enabledCollision"))
  end
end
function RegisterEmbedCallback(fn)
  if embedCallbacks == nil then
    embedCallbacks = {}
  end
  table.insert(embedCallbacks, fn)
end
function FireEmbedCallbacks()
  if embedCallbacks ~= nil then
    for i = 1, #embedCallbacks do
      embedCallbacks[i]()
    end
  end
end
function RegisterUnembedCallback(fn)
  if unembedCallbacks == nil then
    unembedCallbacks = {}
  end
  table.insert(unembedCallbacks, fn)
end
function FireUnembedCallbacks()
  if unembedCallbacks ~= nil then
    for i = 1, #unembedCallbacks do
      unembedCallbacks[i]()
    end
  end
end
function RegisterUnembedStartCallback(fn)
  if unembedStartCallbacks == nil then
    unembedStartCallbacks = {}
  end
  table.insert(unembedStartCallbacks, fn)
end
function FireUnembedStartCallbacks()
  if unembedStartCallbacks ~= nil then
    for i = 1, #unembedStartCallbacks do
      unembedStartCallbacks[i]()
    end
  end
end
function RegisterHitCallback(fn)
  if onHitCallbacks == nil then
    onHitCallbacks = {}
  end
  table.insert(onHitCallbacks, fn)
end
function FireHitCallbacks()
  if onHitCallbacks ~= nil then
    for i = 1, #onHitCallbacks do
      onHitCallbacks[i]()
    end
  end
end
function RegisterPassedThroughCallback(fn)
  if passedThroughCallbacks == nil then
    passedThroughCallbacks = {}
  end
  table.insert(passedThroughCallbacks, fn)
end
function FirePassedThroughCallbacks()
  if passedThroughCallbacks ~= nil then
    for i = 1, #passedThroughCallbacks do
      passedThroughCallbacks[i]()
    end
  end
end
function OnSaveCheckpoint(level)
  return {enabled = enabled}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
end
