local LD = require("design.LevelDesignLibrary")
local thisObj, luaCallbacks, runeObj, mapMarkerID
local questPrefix = "Quest_WorldDragon_"
local damageEventFired, masterAnim
function OnScriptLoaded(level, obj)
  thisObj = obj
  runeObj = thisObj:FindSingleGOByName("runeObj")
  game.SubObject.Sleep(obj)
  if thisObj:FindLuaTableAttribute("MapMarkerName") ~= nil and thisObj:FindLuaTableAttribute("MapMarkerName") ~= "" then
    mapMarkerID = thisObj:FindLuaTableAttribute("MapMarkerName")
  end
  if obj.Parent ~= nil then
    masterAnim = thisObj.Parent:FindSingleGOByName("masterAnim")
  end
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  SoundInit()
  if masterAnim ~= nil then
    masterAnim:PauseAnim()
  end
end
function SelectRune(index)
  for i = 1, 3 do
    local runeVisual = thisObj:FindSingleGOByName("RuneVisual" .. tostring(i))
    if i ~= index then
      runeVisual:Hide()
    end
  end
end
function OnBroken(fn)
  if luaCallbacks == nil then
    luaCallbacks = {}
  end
  luaCallbacks[#luaCallbacks + 1] = fn
end
function ExecuteLuaCallbacks()
  if luaCallbacks ~= nil then
    for _, callback in pairs(luaCallbacks) do
      callback()
    end
  end
end
function OnBreakableDamaged(level, obj, attackerCreature, hitFlags, damage)
  local rumble = {EffectName = "FFB_MEDIUM", Duration = 1}
  local shake = {
    EffectName = "FSE_SHAKE_GENERIC_MEDIUM",
    Duration = 0.2
  }
  local breakDamagedEvent = obj:FindLuaTableAttribute("Event_OnDamaged")
  if masterAnim ~= nil then
    masterAnim:JumpAnimToFrame(0)
    masterAnim:PlayAnimToFrame(15)
  end
  game.FX.SubmitEffect(rumble)
  game.FX.SubmitEffect(shake)
  PlaySoundStatueHit()
  if breakDamagedEvent ~= nil and not damageEventFired then
    LD.ExtractAndExecuteCallbacksForEvent(level, obj, breakDamagedEvent, "Breakable is now Damaged")
    damageEventFired = true
  end
end
function OnHitByWeapon(level, go, attacker, weapon)
  print("HIT BY", go, attacker, weapon)
end
function OnBreakableBroken(level, obj)
  print("BREAKABLE BROKE")
  local breakEventAttr = obj:FindLuaTableAttribute("Event_OnBroken")
  PlaySoundStatueBreak()
  if runeObj ~= nil then
    runeObj:Hide()
  end
  if breakEventAttr ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(level, obj, breakEventAttr, "Breakable is now Broken")
  end
  ExecuteLuaCallbacks()
  FireQuestCheck()
end
function FireQuestCheck()
  if mapMarkerID ~= nil then
    local questToComplete = tostring(questPrefix .. mapMarkerID)
    LD.CompleteQuest(questToComplete)
  end
end
local soundEmitter
local soundEvents = {
  OnHit = "SND_BRK_Dragon_Statue_Hit",
  OnBreak = "SND_BRK_Dragon_Statue_Broken"
}
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDDragonStatue")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function PlaySoundStatueHit()
  LD.PlaySound(soundEmitter, soundEvents.OnHit)
end
function PlaySoundStatueBreak()
  LD.PlaySound(soundEmitter, soundEvents.OnBreak)
end
