local LD = require("design.LevelDesignLibrary")
local thisLevel, thisObj, luaCallbacks
function OnScriptLoaded(level, obj)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnBroken(fn)
  if luaCallbacks == nil then
    luaCallbacks = {}
  end
  luaCallbacks[#luaCallbacks + 1] = fn
end
function ExecuteLuaCallbacks(level, obj)
  if luaCallbacks ~= nil then
    for _, callback in pairs(luaCallbacks) do
      callback(level, obj)
    end
  end
end
function OnBreakableBroken(level, obj)
  local breakEventAttr = obj:FindLuaTableAttribute("Event_OnBroken")
  if breakEventAttr ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(level, obj, breakEventAttr, "Breakable is now Broken")
  end
  ExecuteLuaCallbacks(level, obj)
end
