local LD = require("design.LevelDesignLibrary")
local luaCallbacks, breakableComponent
function OnScriptLoaded(level, obj)
  breakableComponent = obj:GetBreakable()
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnBroken(fn)
  if luaCallbacks == nil then
    luaCallbacks = {}
  end
  luaCallbacks[#luaCallbacks + 1] = fn
end
function ExecuteLuaCallbacks(level, obj)
  if luaCallbacks ~= nil then
    for _, callback in pairs(luaCallbacks) do
      callback(level, obj)
    end
  end
end
function BreakObject()
  if breakableComponent ~= nil and breakableComponent.Broken == false then
    breakableComponent:Break()
  end
end
function OnBreakableBroken(level, obj)
  local breakEventAttr = obj:FindLuaTableAttribute("Event_OnBroken")
  if breakEventAttr ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(level, obj, breakEventAttr, "Breakable is now Broken")
  end
  ExecuteLuaCallbacks(level, obj)
end
function OnBreakableDamaged(level, obj, attackerCreature, hitFlags, damage)
  local damageEventAttr = obj:FindLuaTableAttribute("Event_OnDamaged")
  if damageEventAttr ~= nil then
    LD.ExtractAndExecuteCallbacksForEvent(level, obj, damageEventAttr, "Breakable damaged")
  end
  ExecuteLuaCallbacks(level, obj)
end
