local LD = require("design.LevelDesignLibrary")
local thisLevel, thisObj, luaCallbacks
local hideRune = false
function OnScriptLoaded(level, obj)
  hideRune = obj:GetLuaTableAttribute("hideRune")
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  if hideRune then
    local rune = obj:FindSingleGOByName("RuneSymbol")
    rune:Hide()
  end
end
function OnBroken(fn)
  if luaCallbacks == nil then
    luaCallbacks = {}
  end
  luaCallbacks[#luaCallbacks + 1] = fn
end
function ExecuteLuaCallbacks()
  if luaCallbacks ~= nil then
    for _, callback in pairs(luaCallbacks) do
      callback()
    end
  end
end
function OnBreakableBroken(level, obj)
  LD.ExtractAndExecuteCallbacksForEvent(level, obj, obj:GetLuaTableAttribute("Event_OnBroken"), "Breakable is now Broken")
  obj:HideNavObstacle()
  ExecuteLuaCallbacks()
end
