local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local CCOS = require("camera.camera_oneshot")
local thisObj, thisLevel, player, cameraTargetName, triggerOption, eventTrigger, zoneTriggerName, IsReadyFunction, bSetUpDone, camOneShot, bUseCamera, kDefaultTimeInSeconds, boolName
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  thisObj = obj
  bSetUpDone = false
  triggerOption = thisObj:GetLuaTableAttribute("TriggerOption")
  if triggerOption == "Zone" then
    zoneTriggerName = thisObj:GetLuaTableAttribute("ZoneTrigger")
  elseif triggerOption == "Event" then
    GetAndSetConditionCheck()
  elseif triggerOption == "ZoneAndEvent" then
    zoneTriggerName = thisObj:GetLuaTableAttribute("ZoneTrigger")
    GetAndSetConditionCheck()
  elseif triggerOption == "Bool" then
    boolName = thisObj:GetLuaTableAttribute("BoolTrigger")
  elseif triggerOption == "ZoneAndBool" then
    zoneTriggerName = thisObj:GetLuaTableAttribute("ZoneTrigger")
    boolName = thisObj:GetLuaTableAttribute("BoolTrigger")
  end
end
function OnUpdate(level, obj)
  CheckForReadyCondition()
  if camOneShot ~= nil then
    camOneShot:Update()
  end
end
function OnUseWorld(level, obj)
end
function OnSaveCheckpoint(level, obj)
  return {}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
end
function CheckForReadyCondition()
  if bSetUpDone == false then
    local bDoSetup = false
    if triggerOption == "Zone" then
      if game.World.IsInsideCameraZone(player.WorldPosition, zoneTriggerName) == true then
        bDoSetup = true
      end
    elseif triggerOption == "Event" then
      if IsReadyFunction() == true then
        bDoSetup = true
      end
    elseif triggerOption == "ZoneAndEvent" then
      if IsReadyFunction() == true and game.World.IsInsideCameraZone(player.WorldPosition, zoneTriggerName) == true then
        bDoSetup = true
      end
    elseif triggerOption == "Bool" then
      local bValue = game.Level.GetVariable(boolName)
      if bValue == true then
        bDoSetup = true
      end
    elseif triggerOption == "ZoneAndBool" then
      local bValue = game.Level.GetVariable(boolName)
      if bValue == true and game.World.IsInsideCameraZone(player.WorldPosition, zoneTriggerName) == true then
        bDoSetup = true
      end
    end
    if bDoSetup == true then
      InitializeStartCamera()
      camOneShot:Start()
      bSetUpDone = true
    end
  end
end
function InitializeStartCamera()
  local bUseCamera = thisObj:GetLuaTableAttribute("UseCamera")
  local camname
  if bUseCamera == true then
    camname = thisObj:GetLuaTableAttribute("CameraName")
    if camname == "" then
      camname = nil
      assert(camname, "UseCamera toggle set to true. No camera to use though, fill in the CameraName field.")
    end
  end
  local timeinseconds = thisObj:GetLuaTableAttribute("SubmitTimeInSeconds")
  if 0 < timeinseconds then
    kDefaultTimeInSeconds = timeinseconds
  else
    kDefaultTimeInSeconds = 10
  end
  cameraTargetName = thisObj:GetLuaTableAttribute("CameraTarget")
  if cameraTargetName == "" then
    cameraTargetName = "nothing"
  end
  camOneShot = CCOS.OneShotCamera.New(camname, kDefaultTimeInSeconds)
end
function GetAndSetConditionCheck()
  eventTrigger = thisObj:GetLuaTableAttribute("EventTrigger")
  eventTrigger = LD.ExtractCallbacksForEvent(thisLevel, thisObj, eventTrigger)
  for _, functionCall in ipairs(eventTrigger) do
    if functionCall ~= nil then
      IsReadyFunction = functionCall
      break
    end
  end
  assert(IsReadyFunction, "Unknown Callback function.")
end
function Reset()
  camOneShot = nil
  bSetUpDone = false
end
