local lookAtConsts = require("game.lookAtConsts")
local timer = require("level.timer")
local CCOS = require("camera.camera_oneshot")
local thisObj, player, bPlayCamera, goInteractZone, goSpeedZone, goFrontCollision, goRearCollision, camOneShot_LookAtVendor
local kQuestCameraType = {
  Unassigned = -1,
  GhostInteractCamera = 0,
  HuldraBrothersInteract_LargeTable = 1,
  HuldraBrothersInteract_SmallTable = 2
}
local cameraType
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  goInteractZone = thisObj:FindSingleGOByName("QuestInteractZone")
  goSpeedZone = thisObj:FindSingleGOByName("SpeedZone_QuestCamera")
  goFrontCollision = thisObj:FindSingleGOByName("FrontCollision")
  goRearCollision = thisObj:FindSingleGOByName("RearCollision")
  bPlayCamera = false
  DisableCollision()
  DisableSpeedZone()
  cameraType = kQuestCameraType.Unassigned
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnUpdate(level, obj)
  if bPlayCamera == true and player:IsInsideEntityZone("QuestInteractZone") then
    if cameraType == kQuestCameraType.GhostInteractCamera then
      game.Camera.SubmitCameraByName("PLYR_NAR_QuestCamera")
      game.Camera.SubmitCameraByName("PLYR_NAR_QuestCamera_TA")
    elseif cameraType == kQuestCameraType.HuldraBrothersInteract_LargeTable then
      game.Camera.SubmitCameraByName("PLYR_NAR_HuldraBrosInteract_LargeTable")
    elseif cameraType == kQuestCameraType.HuldraBrothersInteract_SmallTable then
      game.Camera.SubmitCameraByName("PLYR_NAR_HuldraBrosInteract_SmallTable")
    end
  end
  if camOneShot_LookAtVendor ~= nil then
    camOneShot_LookAtVendor:Update()
  end
end
function EnableCamera()
  game.SubObject.Wake(thisObj)
  goInteractZone:Show()
  bPlayCamera = true
  if cameraType == kQuestCameraType.GhostInteractCamera then
    LuaHook_LE_InteractIdle_WaitForInput()
  end
  game.Player.FindPlayer():CallScript("LuaHook_SetQuestGiverMarker", true)
end
function DisableCamera()
  game.SubObject.Sleep(thisObj)
  goInteractZone:Hide()
  bPlayCamera = false
  game.Player.FindPlayer():CallScript("LuaHook_SetQuestGiverMarker", false)
end
function DisableSpeedZone()
  goSpeedZone:Hide()
end
function EnableSpeedZone()
  goSpeedZone:Show()
end
function DisableCollision()
  goFrontCollision:HideCollision()
  goRearCollision:HideCollision()
end
function EnableCollision()
  goFrontCollision:ShowCollision()
  goRearCollision:ShowCollision()
end
function EnableHeadtracking()
  local goGhostInteractModule = thisObj.Parent.Parent
  local goCamTargLookAt
  goCamTargLookAt = goGhostInteractModule:FindSingleGOByName("CamTarg_LookAt_QuestGiver")
  _G.questghost = game.AddGlobalLookAtTarget(goCamTargLookAt, engine.Vector.New(0, 0, 0), lookAtConsts.TargetType.InterestingObject)
  player:ForceLookAtToObject(goCamTargLookAt)
end
function DisableHeadtracking()
  player:ClearForcedLookAtToObject()
end
function SetCameraType(strType)
  cameraType = kQuestCameraType[strType]
end
function DestroyOneShot_LookAtVendor()
  camOneShot_LookAtVendor = nil
end
function ActivateCameraTracking_Vendor()
  camOneShot_LookAtVendor = CCOS.OneShotCamera.New("PLYR_NAR_VendorTracker", 4)
  camOneShot_LookAtVendor:SetCallback(DestroyOneShot_LookAtVendor)
  camOneShot_LookAtVendor:Start()
end
function LuaHook_LE_EnableQuestLookAt()
  player:TriggerMoveEvent("LE_EnableQuestLookAt")
end
function LuaHook_LE_InteractIdle_WaitForInput()
  player:TriggerMoveEvent("LE_InteractIdle_WaitForInput")
end
