local timers = require("level.timer")
local thisLevel, thisObj, player, fActivationDelayInSeconds, fSleepDistance, bHideOnEnter, bHideOnExit, zoneName, bInsideZone, fpCurrentMode
function ExtractMayaTable()
  if thisObj:FindLuaTableAttribute("HideZoneOnEnter") ~= nil then
    bHideOnEnter = thisObj:FindLuaTableAttribute("HideZoneOnEnter")
    if bHideOnEnter == "" then
      bHideOnEnter = false
    end
  end
  if thisObj:FindLuaTableAttribute("HideZoneOnExit") ~= nil then
    bHideOnExit = thisObj:FindLuaTableAttribute("HideZoneOnExit")
    if bHideOnExit == "" then
      bHideOnExit = false
    end
  end
  if thisObj:FindLuaTableAttribute("ActivationDelay") ~= nil then
    fActivationDelayInSeconds = thisObj:FindLuaTableAttribute("ActivationDelay")
  end
  if thisObj:FindLuaTableAttribute("SleepDistance") ~= nil then
    fSleepDistance = thisObj:FindLuaTableAttribute("SleepDistance")
  end
end
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  player = game.Player.FindPlayer()
  if thisObj.Parent ~= nil then
    local zone = thisObj.Parent.Parent
    zoneName = zone:GetName()
  end
  ExtractMayaTable()
  game.SubObject.SetUpdateDisableDistance(thisObj, fSleepDistance)
  bInsideZone = GetCurrentZoneStatus()
  if bInsideZone == true then
    if bHideOnEnter == true then
      fpCurrentMode = CheckForEnter
    else
      fpCurrentMode = CheckForExit
    end
  else
    fpCurrentMode = Listen
  end
  WarningCheck()
end
function WarningCheck()
  if bHideOnEnter == true and bHideOnExit == true then
    engine.Warning(nil, " CamZoneHider says you set both options. Only set one: OnZoneEnter/OnZoneExit for zone: ", zoneName)
  end
  if bHideOnEnter == false and bHideOnExit == false then
    engine.Warning("CamZoneHider: No options were set for zone: ", zoneName)
  end
end
function OnStart(level, obj)
  fpCurrentMode()
end
function OnUpdate(level, obj)
  print("Updating: ", zoneName)
  bInsideZone = GetCurrentZoneStatus()
  fpCurrentMode()
end
function Listen()
  if bInsideZone == true then
    if bHideOnEnter == true then
      fpCurrentMode = CheckForEnter
    else
      fpCurrentMode = CheckForExit
    end
  end
end
function HideCameraZone()
  local camzone = thisLevel:GetGameObject(zoneName)
  camzone:HideCameraVolume()
end
function GetCurrentZoneStatus()
  return game.World.IsInsideCameraZone(player.WorldPosition, zoneName)
end
function CheckForEnter()
  if 0 < fActivationDelayInSeconds then
    timers.StartLevelTimer(fActivationDelayInSeconds, HideCameraZone)
  else
    HideCameraZone()
  end
  game.SubObject.Sleep(thisObj)
end
function CheckForExit()
  if bInsideZone == true then
    return
  end
  if 0 < fActivationDelayInSeconds then
    timers.StartLevelTimer(fActivationDelayInSeconds, HideCameraZone)
  else
    HideCameraZone()
  end
  game.SubObject.Sleep(thisObj)
end
