local thisObj, player, zoneName, bRetriggerable, thisRecenterTable, bWasInsidePreviously, bAlreadyTriggered, kStates, fp
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  bAlreadyTriggered = false
  thisRecenterTable = ExtractMayaTableAndFillInRecentertable()
  kStates = {
    ExitCheck = CheckForExit,
    EntryCheck = CheckForEntry
  }
  game.SubObject.SetUpdateDisableDistance(obj, 10)
end
function OnStart(level, obj)
  if game.World.IsInsideCameraZone(player.WorldPosition, zoneName) == true then
    fp = kStates.ExitCheck
    bWasInsidePreviously = true
  else
    fp = kStates.EntryCheck
    bWasInsidePreviously = false
  end
end
function GetCurrentZoneStatus()
  if game.World.IsInsideCameraZone(player.WorldPosition, zoneName) == true then
    return true
  else
    return false
  end
end
function CheckForExit()
  local bInsideZone = GetCurrentZoneStatus()
  if bWasInsidePreviously == true and bInsideZone == false then
    bWasInsidePreviously = false
    fp = kStates.EntryCheck
    if bRetriggerable == true then
      bAlreadyTriggered = false
    end
  end
end
function CheckForEntry()
  local bInsideZone = GetCurrentZoneStatus()
  if bInsideZone == true then
    if bAlreadyTriggered ~= true then
      game.Camera.Recenter(thisRecenterTable)
      bAlreadyTriggered = true
    end
    if bRetriggerable ~= true then
      game.SubObject.Sleep(thisObj)
      bAlreadyTriggered = false
    end
  end
  if bWasInsidePreviously == false and bInsideZone == true then
    bWasInsidePreviously = true
    fp = kStates.ExitCheck
  end
end
function OnUpdate(level, obj)
  if fp ~= nil then
    fp()
  end
end
function ExtractMayaTableAndFillInRecentertable()
  local recentertable = {
    TimeStart = 0,
    TimeDuration = 2,
    MoveStart = -1,
    MoveDistance = 0,
    EaseIn = 1,
    EaseOut = 1,
    YawRange = -1,
    PitchRange = -1,
    TriggerLeft = 0,
    ReturnLeft = 0,
    ReturnRight = 0,
    TriggerRight = 0,
    TriggerUp = 0,
    ReturnUp = 0,
    ReturnDown = 0,
    TriggerDown = 0,
    LockRecenter = 0
  }
  local modifiedTable = {}
  for k, _ in pairs(recentertable) do
    recentertable[k] = thisObj:FindLuaTableAttribute(k)
  end
  if thisObj:FindLuaTableAttribute("Retriggerable") ~= nil then
    bRetriggerable = thisObj:FindLuaTableAttribute("Retriggerable")
  end
  if thisObj:FindLuaTableAttribute("CameraZone") ~= nil then
    zoneName = thisObj:FindLuaTableAttribute("CameraZone")
  end
  if thisObj:FindLuaTableAttribute("UseWorldRotation") ~= nil and thisObj:FindLuaTableAttribute("UseWorldRotation") == true then
    recentertable.RotationSpace = 1
  end
  return recentertable
end
function Reset()
  if game.World.IsInsideCameraZone(player.WorldPosition, zoneName) == true then
    fp = kStates.ExitCheck
    bWasInsidePreviously = true
  else
    fp = kStates.EntryCheck
    bWasInsidePreviously = false
  end
  bAlreadyTriggered = false
end
