local EC = require("design.Encounter")
LD = require("design.LevelDesignLibrary")
monitors = require("level.MonitorLibrary")
player = nil
thisLevel = nil
thisObj = nil
thisEncounter = nil
zoneName = nil
myInitialSpawns = nil
myTotalSpawns = nil
myMaxActive = nil
onStartEvents = nil
onCompleteEvents = nil
zoneObj = nil
zoneStartMonitor = nil
startOnLoad = nil
function OnScriptLoaded(level, obj)
  player = game.Player.FindPlayer()
  thisLevel = level
  thisObj = obj
  zoneName = obj:GetLuaTableAttribute("StartEncounter_ZoneObjectName")
  startOnLoad = obj:GetLuaTableAttribute("StartOnLoad")
  if zoneName ~= "" then
    zoneObj = level:GetGameObject(zoneName)
    zoneStartMonitor = monitors.CreateEntityZoneMonitor(player, zoneObj)
    zoneStartMonitor:OnEnter(StartEncounter)
  end
  myInitialSpawns = obj:GetLuaTableAttribute("InitialSpawns")
  myTotalSpawns = obj:GetLuaTableAttribute("TotalSpawns")
  myMaxActive = obj:GetLuaTableAttribute("MaxActive")
  if obj:FindLuaTableAttribute("Event_OnStart") ~= nil then
    onStartEvents = LD.ExtractCallbacksForEvent(level, obj, obj:FindLuaTableAttribute("Event_OnStart"))
  end
  if obj:FindLuaTableAttribute("Event_OnComplete") ~= nil then
    onCompleteEvents = LD.ExtractCallbacksForEvent(level, obj, obj:FindLuaTableAttribute("Event_OnComplete"))
  end
  thisEncounter = EC.NewEncounter(level, "Medium_24x24_DraugrGround")
  thisEncounter:AddWave({
    {
      spawners = obj:FindGOsByName("Enc_Med_Med_DraugrGroundSpawn*"),
      initialSpawnAmount = myInitialSpawns or 4,
      maxActive = myMaxActive or 4,
      totalSpawns = myTotalSpawns or 10,
      initialSpawnCooldown = {0.1, 0.2},
      spawnCooldown = {1, 3}
    }
  })
  if startOnLoad then
    StartEncounter()
  end
  thisEncounter:OnComplete(EncounterComplete)
end
function StartEncounter()
  if thisEncounter ~= nil then
    thisEncounter:Start()
  end
  if onStartEvents ~= "" then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onStartEvents, "EncounterStartedEvents")
  end
end
function EncounterComplete()
  if onCompleteEvents ~= "" then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onCompleteEvents, "EncounterCompleteEvents")
  end
end
function StartEncounter()
  thisEncounter:Start()
end
