local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local spawnDone, spawnStarted, spawnAnimObj, combatStartedEvent, spawningEndedEvent, thisLevel, thisObj, spawnFX
function OnScriptLoaded(level, obj)
  thisLevel = level
  thisObj = obj
  print("Spawn FX", spawnFX)
  spawnAnimObj = obj.Parent:FindSingleGOByName("SpawnAnim")
  if spawnAnimObj ~= nil then
    spawnAnimObj:PauseAnim()
  end
  if obj:FindLuaTableAttribute("combatStartedEvent") ~= nil then
    combatStartedEvent = LD.ExtractCallbacksForEvent(thisLevel, thisObj, obj:FindLuaTableAttribute("combatStartedEvent"))
  end
  if obj:FindLuaTableAttribute("spawningEndedEvent") ~= nil then
    spawningEndedEvent = LD.ExtractCallbacksForEvent(thisLevel, thisObj, obj:FindLuaTableAttribute("spawningEndedEvent"))
  end
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnStart(level, obj)
end
function OnUseWorld(level, obj)
end
function StartCombatState()
  PlayTransitionFX()
  if combatStartedEvent ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, combatStartedEvent, "combatStartedEvent")
  end
  local spawnFXTimer = StartLevelTimer(0.2, TriggerSpawnFX)
  PlaySoundOnInteract_CombatPortal()
end
function TriggerSpawnFX()
  spawnFX = game.FX.Spawn("pocketrift_spawn", thisLevel, {
    GameObject = spawnAnimObj,
    Joint = "fxSpawnPoint",
    Follow = true
  })
  spawnStarted = true
  spawnAnimObj:PlayAnimToFrame(30)
  spawnAnimObj:SetAnimRate(2)
end
function SpawningDone()
  local shutOffTimer = StartLevelTimer(1, PlayTransitionFX)
  spawnAnimObj:PlayAnimToFrame(75)
  spawnAnimObj:SetAnimRate(2)
  if spawningEndedEvent ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, spawningEndedEvent, "combatEndedEvent")
  end
  PlaySoundCombatPortalClose()
end
function PlayTransitionFX()
  if spawnStarted then
    spawnAnimObj = thisObj.Parent:FindSingleGOByName("SpawnAnim")
    if spawnAnimObj ~= nil then
      spawnAnimObj:Hide()
    end
    if spawnFX ~= nil and spawnFX.Spawned then
      spawnFX:Remove()
    end
    spawnDone = true
    local spawn_transitionFX = game.FX.Spawn("pocketrift_spawn_transition", thisLevel, {
      GameObject = thisObj,
      Joint = "fxSpawnPointEnd",
      AutoDelete = true
    })
  else
    local spawn_transitionFX = game.FX.Spawn("pocketrift_spawn_transition", thisLevel, {
      GameObject = thisObj,
      Joint = "fxSpawnPointB",
      AutoDelete = true
    })
  end
end
function OnSaveCheckpoint(level, obj)
  return {spawnDone = spawnDone}
end
function OnRestoreCheckpoint(level, obj, tab)
  spawnDone = tab.spawnDone
end
local soundEmitter
local soundEvents = {
  CombatPortalOpen = "SND_LOOT_Rift_Pocket_Portal_Gate_Open",
  CombatPortalClose = "SND_LOOT_Rift_Pocket_Portal_Gate_Close",
  CombatPortalEnemySpawn = "SND_LOOT_Rift_Pocket_Portal_Gate_Enemy_Exit",
  CombatPortalLoop = "SND_LOOT_Rift_Pocket_Portal_LP"
}
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDPocketRift")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function PlaySoundOnInteract_CombatPortal()
  LD.PlaySound(soundEmitter, soundEvents.CombatPortalOpen)
  PlaySoundCombatPortalLoop()
end
function PlaySoundCombatPortalClose()
  StopSoundCombatPortalLoop()
  LD.PlaySound(soundEmitter, soundEvents.CombatPortalClose)
end
function PlaySoundCombatPortalLoop()
  LD.PlaySound(soundEmitter, soundEvents.CombatPortalLoop)
end
function StopSoundCombatPortalLoop()
  LD.StopSound(soundEmitter, soundEvents.CombatPortalLoop)
end
function PlaySoundCombatPortalEnemySpawn()
  LD.PlaySound(soundEmitter, soundEvents.CombatPortalEnemySpawn)
end
