local contextactionlibrary = require("level.contextactionlibrary")
local thisObj, thisLevel, attributes, puppeteer
local persistentState = {}
function OnScriptLoaded(level, obj)
  thisLevel, thisObj = level, obj
  attributes = contextactionlibrary.CollectLuaTableAttributes(thisLevel, thisObj)
  persistentState.enabled = attributes.EnabledAtLevelStart or nil
  if attributes.Props then
    for _, v in pairs(attributes.Props) do
      v:Hide()
    end
  end
  game.SubObject.Sleep(thisObj)
end
function OnRestoreCheckpoint(level, obj, data)
  persistentState = data
end
function OnSaveCheckpoint(level, obj)
  return persistentState
end
function OnStart(level, obj)
  if persistentState.enabled then
    Enable()
  end
end
function OnUpdate(level, obj)
  if persistentState.enabled and puppeteer ~= nil then
    contextactionlibrary.UpdatePuppeteer(puppeteer, thisLevel, thisObj, attributes)
  end
end
local StartAdvertising = function()
  if puppeteer == nil or not puppeteer:Valid() then
    puppeteer = nil
    puppeteer = contextactionlibrary.CreatePuppeteer(thisLevel, thisObj, attributes, persistentState)
  else
    contextactionlibrary.CancelQueuedEnd(puppeteer)
  end
end
local StopAdvertising = function()
  if puppeteer ~= nil then
    contextactionlibrary.DisablePuppeteer(puppeteer)
  end
end
function Enable()
  StartAdvertising()
  persistentState.enabled = true
end
function Disable()
  if persistentState.enabled == false then
    return
  end
  persistentState.enabled = false
  StopAdvertising()
end
function TriggerLoopAction()
  contextactionlibrary.ForceLoopAction(puppeteer)
end
function Interrupt()
  if puppeteer ~= nil then
    contextactionlibrary.InterruptPuppeteer(puppeteer)
  end
end
function IsEnabled()
  return persistentState.enabled
end
function OnEnvironmentEvent(level, obj, event)
  if puppeteer ~= nil and puppeteer:Valid() then
    contextactionlibrary.OnEnvironmentEvent(puppeteer, event)
    return true
  end
end
