local son, baseObjectScript
local maxEnemyDisableRange = 0
local updateTimer = 0
local updateTimerMax = 0.5
function OnScriptLoaded(level, obj)
  baseObjectScript = obj:FindSingleGOByName("GenericPOI").Child.LuaObjectScript
  son = game.AI.FindSon()
  maxEnemyDisableRange = obj:FindLuaTableAttribute("EnemyWithinRangeDisableDistance")
  if maxEnemyDisableRange == 0 then
    game.SubObject.Sleep(obj)
    game.SubObject.SetForgetOnCheckpoint(obj)
    obj:SetInhibitSave()
  end
end
function OnUpdate(level, obj)
  updateTimer = updateTimer + level:GetUnitTime()
  if updateTimer < updateTimerMax then
    return
  end
  if not game.Combat.GetCombatStatus() then
    return
  end
  updateTimer = 0
  local enemy = son:GetTargetCreature()
  if enemy ~= nil and obj:GetWorldPosition():Distance(enemy:GetWorldPosition()) < maxEnemyDisableRange then
    baseObjectScript.Interrupt()
  end
end
function Enable()
  baseObjectScript.Enable()
end
function Disable()
  baseObjectScript.Disable()
end
function Interrupt()
  baseObjectScript.Interrupt()
end
function TriggerLoopAction()
  baseObjectScript.TriggerLoopAction()
end
function IsEnabled()
  baseObjectScript.IsEnabled()
end
function OnEnvironmentEvent(level, obj, event)
  baseObjectScript.OnEnvironmentEvent(level, obj, event)
end
