local LD = require("design.LevelDesignLibrary")
local thisObj
local currentState = 1
local flipperModule
local runes = {}
function OnScriptLoaded(level, obj)
  thisObj = obj
  flipperModule = thisObj:FindSingleGOByName("FlipperModule").Child
  local numberOfRunes = obj:GetLuaTableAttribute("NumberOfRunes")
  local runeVisual
  for i = 1, numberOfRunes do
    local successRune = thisObj:FindLuaTableAttribute("SuccessRune_0" .. tostring(i))
    local runeObj = thisObj:FindSingleGOByName("Rune" .. tostring(i))
    table.insert(runes, {runeVisual = runeObj, runeNumber = successRune})
  end
  flipperModule.LuaObjectScript.RegisterOnRotateCallback(OnRotate)
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
  SoundInit()
end
function OnPreStart(level, obj)
  currentState = flipperModule.LuaObjectScript.GetCurrentState()
  for i = 1, #runes do
    runes[i].runeVisual.LuaObjectScript.SelectRune(runes[i].runeNumber)
  end
end
function OnRotate(newState)
  currentState = newState
  PlayHitSound()
end
function GetCurrentRune()
  return runes[currentState].runeNumber
end
function EnableRunes()
  for i = 1, #runes do
    runes[i].runeVisual.LuaObjectScript.Enable()
  end
end
function DisableRunes()
  for i = 1, #runes do
    runes[i].runeVisual.LuaObjectScript.Disable()
  end
end
function ShowRunes()
  for i = 1, #runes do
    runes[i].runeVisual.LuaObjectScript.ShowRune()
  end
end
function HideRunes()
  for i = 1, #runes do
    runes[i].runeVisual.LuaObjectScript.HideRune()
  end
end
function EnableRotation()
  flipperModule.LuaObjectScript.EnableRotation()
end
function DisableRotation()
  flipperModule.LuaObjectScript.DisableRotation()
end
function ResetRotateCW()
  return flipperModule.LuaObjectScript.ResetRotateCW()
end
function ResetRotateCCW()
  return flipperModule.LuaObjectScript.ResetRotateCCW()
end
function RegisterOnResetCallback(fn)
  flipperModule.LuaObjectScript.RegisterOnResetCallback(fn)
end
local soundEmitter
local soundEvents = {
  OnHit = "SND_MECH_Temple_Entrance_Door_Spindle_Turn",
  OnReset = "",
  OnRotateStop = ""
}
local soundCWObject, soundCCWObject
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDSpinner")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
    flipperModule.LuaObjectScript.SoundSetup({
      OnReset = soundEvents.OnReset,
      OnRotateStop = soundEvents.OnRotateStop
    })
  end
end
function PlayHitSound()
  if flipperModule.LuaObjectScript.AllowHitSound() then
    LD.PlaySound(soundEmitter, soundEvents.OnHit)
  end
end
function PlaySoundOnFlipper_Remote(remoteSoundEvent)
  LD.PlaySound(soundEmitter, remoteSoundEvent)
end
function ShowDebugText()
  local color = require("core.color")
  local debugText = "FlipperRefNode: " .. thisObj.Parent:GetName()
  debugText = debugText .. [[

>My Flip State ]] .. tostring(currentState)
  debugText = debugText .. [[

>Flippable Moduale State ]] .. tostring(flipperModule.LuaObjectScript.GetCurrentState())
  debugText = debugText .. "\n" .. flipperModule.LuaObjectScript.GetDebugText()
  engine.DrawTextInWorld(thisObj:GetWorldPosition(), debugText, color.white)
end
