local LD = require("design.LevelDesignLibrary")
local thisObj, bEnabled, tCollisionDefinition
function OnScriptLoaded(level, obj)
  thisObj = obj
  tCollisionDefinition = thisObj:GetLuaTableAttribute("tCollisionDefinition")
  bEnabled = thisObj:GetLuaTableAttribute("bEnabledOnStart")
  game.SubObject.Sleep(thisObj)
end
function OnSaveCheckpoint(level, obj)
  return {bEnabled = bEnabled, tCollisionDefinition = tCollisionDefinition}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bEnabled = savedInfo.bEnabled
  tCollisionDefinition = savedInfo.tCollisionDefinition
end
local UpdateCombatCollision = function()
  if bEnabled then
    game.Combat.AddSubObjectCombatCollision(thisObj, tCollisionDefinition)
  else
    game.Combat.RemoveSubObjectCombatCollision(thisObj, tCollisionDefinition)
  end
end
function OnStart(level, obj)
  UpdateCombatCollision()
end
function Enable()
  if bEnabled then
    return
  end
  bEnabled = true
  UpdateCombatCollision()
end
function Disable()
  if not bEnabled then
    return
  end
  bEnabled = false
  UpdateCombatCollision()
end
function IsEnabled()
  return bEnabled
end
function ChangeCombatCollisionType(tCollisionDefinition_new)
  if bEnabled then
    game.Combat.RemoveSubObjectCombatCollision(thisObj, tCollisionDefinition)
    game.Combat.AddSubObjectCombatCollision(thisObj, tCollisionDefinition_new)
  end
  tCollisionDefinition = tCollisionDefinition_new
end
