local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local thisLevel, thisObj, RevealAnimObj, DegradeAnimObj
local Colors = {}
local ActiveColor = "None"
local ColorFrames = {
  Green = 251,
  Yellow = 501,
  Orange = 751,
  Red = 800,
  BrightRed = 900
}
local playRate = 0
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  RevealAnimObj = GameObjects.anim_all
  DegradeAnimObj = GameObjects.anim_degrade
  game.SubObject.Sleep(obj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function Enable()
  RevealCircle()
end
function Disable()
  RetractCircle()
end
function RevealCircle()
  DegradeAnimObj:JumpAnimToFrame(1000)
  timer.StartLevelTimer(1, RechargeCircle)
end
function RetractCircle()
  RevealAnimObj:PlayAnimToEnd(-1)
end
function GetPlayRate(targetFrame, time)
  return math.abs(DegradeAnimObj.AnimFrame - targetFrame) / time * thisLevel:GetUnitTime()
end
function RechargeCircle()
  DegradeAnimObj:PauseAnim()
  timer.StartLevelTimer(3, function()
    DegradeAnimObj:PlayAnimToEnd(-GetPlayRate(0, 0.5) / 4)
    DegradeAnimObj:OnAnimationDone(thisObj, "OnDegradeAnimDone_Recharge", {Force = true})
  end)
end
function DegradeCircle(targetFrame, time)
  playRate = GetPlayRate(targetFrame, time)
  DegradeAnimObj:PlayAnimToFrame(targetFrame, playRate)
  DegradeAnimObj:OnAnimationDone(thisObj, "OnDegradeAnimDone_Degrade", {Force = true})
end
function OnDegradeAnimDone_Recharge()
  DegradeAnimObj:ClearAllAnimCallbacks()
end
function OnDegradeAnimDone_Degrade()
  DegradeAnimObj:ClearAllAnimCallbacks()
end
