local LD = require("design.LevelDesignLibrary")
local monitors = require("level.MonitorLibrary")
local flipper, sawBladeObj, bStartActive, GO_CombatCollision, thisObj
function OnScriptLoaded(level, obj)
  thisObj = obj
  flipper = obj:FindSingleGOByName("FlipperModule")
  sawBladeObj = obj:FindSingleGOByName("sawBlade_Blade")
  if sawBladeObj.IsRefNode == true then
    sawBladeObj = sawBladeObj.Child
  end
  GO_CombatCollision = obj:FindSingleGOByName("CombatCollision")
  bStartActive = obj:GetLuaTableAttribute("bStartActive")
  SoundInit()
  flipper.LuaObjectScript.RegisterOnRotateCallback(PlayFlipper)
  PlaySawLoop()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  local rotator = obj:FindSingleGOByName("rotator")
  rotator:JumpAnimToFrame(obj:GetLuaTableAttribute("RotateStartAngle"))
  rotator:PauseAnim()
end
function OnStart(level, obj)
  if bStartActive then
    Start()
  else
    Stop()
  end
end
function OnSaveCheckpoint(level, obj)
  return {bStartActive = bStartActive}
end
function OnRestoreCheckpoint(level, obj, p)
  bStartActive = p.bStartActive
end
function Start()
  bStartActive = true
  sawBladeObj:StartAnim("bladeRotate_Start")
  sawBladeObj:OnAnimationDone(thisObj, "Start_BladeLoop", {
    Animation = "bladeRotate_Start",
    Force = true
  })
  GO_CombatCollision.LuaObjectScript.Enable()
  PlaySawLoop()
end
function Start_BladeLoop()
  sawBladeObj:StartAnim("bladeRotate")
  sawBladeObj:PlayAnimCycle(1)
end
function Stop()
  bStartActive = false
  sawBladeObj:StartAnim("bladeRotate_Stop")
  GO_CombatCollision.LuaObjectScript.Disable()
  StopSawLoop()
end
local soundEmitter
local soundEvents = {
  SawLoop = "SND_TRAP_Saw_Blades_LP",
  Flipper = "SND_TRAP_Saw_Blades_Flip"
}
function SoundInit()
  soundEmitter = thisObj:FindSingleGOByName("SNDGrpSawBladeEmitter").SoundEmitters[1]
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for k, v in pairs(soundEvents) do
      for i, j in pairs(sounds) do
        if i == k and j ~= nil and j ~= "" then
          soundEvents[k] = j
        end
      end
      LD.SoundDebug(tostring(k) .. ": " .. tostring(v))
    end
  end
end
function PlaySawLoop()
  LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.SawLoop)
end
function StopSawLoop()
  LD.StopRestartableSoundLoop(soundEmitter, soundEvents.SawLoop)
end
function PlayFlipper()
  LD.PlaySound(soundEmitter, soundEvents.Flipper)
end
