local LD = require("design.LevelDesignLibrary")
local timer = require("level.timer")
local monitors = require("level.MonitorLibrary")
local thisObj, markerZoneObj, objectMarkerName, player, GO_CombatCollision
local timers = {}
local poisonOnParticles = {
  cloudLoop = "PoisonCloudOn_Loop",
  cloud = "PoisonCloudOn_VFXs",
  pole = "Poison_Fire_VFX_visOn"
}
local poisonOffParticles = {
  cloudLoop = "PoisonCloudOff_Loop",
  cloud = "PoisonCloudOff",
  pole = "ScornPoleOff"
}
local Breakable
function OnScriptLoaded(level, obj)
  thisObj = obj
  player = game.Player.FindPlayer()
  poisonOnParticles.pole = thisObj:FindSingleGOByName(poisonOnParticles.pole)
  poisonOnParticles.cloud = thisObj:FindSingleGOByName(poisonOnParticles.cloud)
  poisonOnParticles.cloudLoop = thisObj:FindSingleGOByName(poisonOnParticles.cloudLoop)
  poisonOffParticles.cloudLoop = thisObj:FindSingleGOByName(poisonOffParticles.cloudLoop)
  poisonOffParticles.cloud = thisObj:FindSingleGOByName(poisonOffParticles.cloud)
  poisonOffParticles.pole = thisObj:FindSingleGOByName(poisonOffParticles.pole)
  Breakable = thisObj:FindSingleGOByName("Breakable")
  Breakable.LuaObjectScript.OnBroken(Ice)
  GO_CombatCollision = thisObj:FindSingleGOByName("CombatCollision")
  SoundInit()
  objectMarkerName = tostring(thisObj.Parent:GetName()) .. "_Marker"
  markerZoneObj = thisObj:FindSingleGOByName("ScornAreaMarkerZone")
  game.SubObject.SetEntityZoneHandler(thisObj, markerZoneObj)
  game.SubObject.SetEntityZoneHandler(thisObj, thisObj)
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(obj)
end
function OnFirstStart(level, obj)
  DisableEmitters(poisonOffParticles.cloudLoop, true)
  DisableEmitters(poisonOffParticles.cloud, true)
  DisableEmitters(poisonOffParticles.pole, true)
end
function OnStart(level, obj)
  if GO_CombatCollision.LuaObjectScript.IsEnabled() == true then
    LD.CallFunctionAfterDelay(PlaySoundPoisonOn, 0.5)
  else
    LD.CallFunctionAfterDelay(StopSoundPoisonOff, 0.5)
  end
  if player:IsInsideEntityZone(markerZoneObj) then
    OnMarkerEnterZone(level, thisObj, markerZoneObj, player, game.LargeInteger.HashString(3))
  end
  if player:IsInsideEntityZone(thisObj) then
    OnMarkerEnterZone(level, thisObj, thisObj, player, game.LargeInteger.HashString(3))
  end
end
function Ice()
  print("BreakSuccess")
  if timers ~= {} then
    for _, v in pairs(timers) do
      if v.fired == false then
        v:Finish()
      end
    end
  end
  timers = {}
  GO_CombatCollision.LuaObjectScript.Disable()
  thisObj:HideNavObstacle()
  HideEntityZones()
  DisableEmitters(thisObj, true)
  DisableEmitters(poisonOnParticles.cloudLoop, true)
  DisableEmitters(poisonOnParticles.cloud)
  DisableEmitters(poisonOnParticles.pole)
  PlaySoundOnIce()
  StopSoundPoisonOff()
end
function EnableEmitters(obj, loopAnim)
  if obj ~= nil then
    obj:ShowModel()
    obj:JumpAnimToFrame(0)
    if loopAnim then
      obj:PlayAnimCycle()
    else
      obj:PlayAnimToEnd()
    end
    obj:ShowParticleEmitter()
    obj:ShowLights()
  end
end
function DisableEmitters(obj, hideModel)
  if obj ~= nil then
    obj:PauseAnim()
    obj:HideParticleEmitter()
    obj:HideLights()
    if hideModel then
      obj:HideModel()
    end
  end
end
function HideEntityZones()
  thisObj:HideEntityVolume()
  markerZoneObj:HideEntityVolume()
end
function ShowEntityZones()
  thisObj:ShowEntityVolume()
  markerZoneObj:ShowEntityVolume()
end
local markerObjInEntityZone = false
function OnMarkerEnterZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  if game.LargeInteger.HashString(objectMarkerName) == markerId and volumeGameObject == markerZoneObj then
    player:CallScript("LuaHook_DisableRevive", true)
    markerObjInEntityZone = true
  end
  if game.LargeInteger.HashString(3) == markerId or game.LargeInteger.HashString(3) == game.LargeInteger.HashString(tostring(markerId)) then
    if volumeGameObject == markerZoneObj and not player:HasMarker(objectMarkerName) then
      player:AddMarkerPointTest(objectMarkerName, player:GetJointIndex("defense02_shoulders"))
    elseif volumeGameObject == thisObj then
      player:CallScript("LuaHook_DisableRevive", true)
    end
  end
end
function OnMarkerExitZone(level, scriptObj, volumeGameObject, markerGameObject, markerId)
  if game.LargeInteger.HashString(objectMarkerName) == markerId and player:IsDead() == false and player:IsDying() == false and volumeGameObject == markerZoneObj then
    player:CallScript("LuaHook_DisableRevive", false)
    markerObjInEntityZone = false
  end
  if game.LargeInteger.HashString(3) == markerId or game.LargeInteger.HashString(3) == game.LargeInteger.HashString(tostring(markerId)) then
    if volumeGameObject == markerZoneObj and player:HasMarker(objectMarkerName) then
      player:RemoveMarker(objectMarkerName)
    elseif volumeGameObject == thisObj and not markerObjInEntityZone then
      player:CallScript("LuaHook_DisableRevive", false)
    end
  end
end
local soundEmitter
local soundEvents = {
  isLooping = false,
  OnIce = "SND_TRAP_Scorn_Stone_Explosion",
  PoisonOn = "SND_TRAP_Scorn_Stone_Cloud_LP"
}
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDPoisonCloudBreak")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key, value in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(value))
    end
  end
end
function PlaySoundPoisonOn()
  LD.PlayRestartableSoundLoop(soundEmitter, soundEvents.PoisonOn)
end
function StopSoundPoisonOff()
  LD.StopRestartableSoundLoop(soundEmitter, soundEvents.PoisonOn)
end
function PlaySoundOnIce()
  LD.PlaySound(soundEmitter, soundEvents.OnIce)
end
