local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj, combatCollision
local animSpeed = 1.75
local wasTriggered = false
local extendedOnStart = false
local retractAfterHit = false
local extendAfterRetract = false
local extendDelay = 0
local onRetract, onExtend, onStartRetracting, onStartExtending, enabled, thisLevel
local retractTrapAnimName = ""
local triggerTrapAnimName = ""
local extendTimer
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  combatCollision = thisObj:FindSingleGOByName("CombatCollisionManager")
  enabled = obj:GetLuaTableAttribute("StartEnabled")
  extendedOnStart = obj:GetLuaTableAttribute("Extended_OnStart")
  extendAfterRetract = obj:GetLuaTableAttribute("ExtendAfterRetract")
  extendDelay = obj:GetLuaTableAttribute("ExtendAfterRetract_Delay")
  retractAfterHit = obj:GetLuaTableAttribute("RetractAfterHit")
  onRetract = obj:GetLuaTableAttribute("OnRetract")
  onExtend = obj:GetLuaTableAttribute("OnExtend")
  onStartRetracting = obj:GetLuaTableAttribute("OnStart_Retracting")
  onStartExtending = obj:GetLuaTableAttribute("OnStart_Extending")
  onRetract = LD.ExtractCallbacksForEvent(level, obj, onRetract)
  onExtend = LD.ExtractCallbacksForEvent(level, obj, onExtend)
  onStartRetracting = LD.ExtractCallbacksForEvent(level, obj, onStartRetracting)
  onStartExtending = LD.ExtractCallbacksForEvent(level, obj, onStartExtending)
  if onRetract == "" then
    onRetract = nil
  end
  if onExtend == "" then
    onExtend = nil
  end
  if onStartRetracting == "" then
    onStartRetracting = nil
  end
  if onStartExtending == "" then
    onStartExtending = nil
  end
  retractTrapAnimName = "envGlobtrapSpike00Down"
  triggerTrapAnimName = "envGlobtrapSpike00Up"
  SoundInit()
  game.SubObject.Sleep(obj)
end
function OnFirstStart(level, obj)
  combatCollision.LuaObjectScript.Disable()
  if extendedOnStart == true then
    TriggerTrap()
  end
end
function OnSaveCheckpoint(level, obj)
  return {wasTriggered = wasTriggered, enabled = enabled}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  wasTriggered = savedInfo.wasTriggered
  enabled = savedInfo.enabled
end
function Enable()
  enabled = true
  thisObj:ShowNavObstacle()
end
function Disable()
  enabled = false
  combatCollision.LuaObjectScript.Disable()
  thisObj:HideNavObstacle()
end
function IsEnabled()
  return enabled
end
function DisarmTrap()
  if enabled == true and (extendTimer == nil or extendTimer:GetRemainingTime() <= 0) then
    wasTriggered = true
    thisObj:HideCollision()
    timers.StartLevelTimer(0.35, function()
      combatCollision.LuaObjectScript.Enable()
      thisObj:StartAnim(triggerTrapAnimName)
      thisObj:PlayAnimToEnd(animSpeed)
      PlaySoundSpikesExtend()
      thisObj:OnAnimDone(thisObj, "FinishTrap")
    end)
  end
end
function TriggerTrap()
  if enabled == true and (extendTimer == nil or extendTimer:GetRemainingTime() <= 0) then
    wasTriggered = true
    thisObj:HideCollision()
    combatCollision.LuaObjectScript.Enable()
    thisObj:StartAnim(triggerTrapAnimName)
    thisObj:PlayAnimToEnd(animSpeed)
    PlaySoundSpikesExtend()
    if onStartExtending then
      LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onStartExtending, "On Start Extending Event")
    end
    thisObj:OnAnimDone(thisObj, "FinishTrap")
    if retractAfterHit and extendAfterRetract == false then
      thisObj:OnAnimDone(thisObj, "ResetTrap")
    end
  end
end
function FinishTrap()
  if onExtend then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onExtend, "On Extend Event")
  end
  thisObj:ClearAllAnimCallbacks()
  combatCollision.LuaObjectScript.Disable()
  thisObj:ShowCollision()
end
function ResetTrap()
  if enabled == true and (extendTimer == nil or extendTimer:GetRemainingTime() <= 0) then
    wasTriggered = false
    thisObj:ClearAllAnimCallbacks()
    combatCollision.LuaObjectScript.Disable()
    thisObj:StartAnim(retractTrapAnimName)
    PlaySoundSpikesRetract()
    if onStartRetracting then
      LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onStartRetracting, "On Retract Event")
    end
    thisObj:OnAnimDone(thisObj, "FinishResetTrap")
  end
end
function FinishResetTrap()
  if onRetract then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onRetract, "On Retract Event")
  end
  thisObj:ClearAllAnimCallbacks()
  timers.StartLevelTimer(0.5, function()
    thisObj:ShowParticleEmitter()
    if 0 < extendDelay and extendAfterRetract == true and retractAfterHit == false then
      if extendTimer ~= nil then
        extendTimer:Stop()
        extendTimer = nil
      end
      extendTimer = timers.StartLevelTimer(extendDelay, TriggerTrap)
    end
  end)
end
function ToggleTrap()
  if wasTriggered == true then
    ResetTrap()
  else
    TriggerTrap()
  end
end
local soundEmitter
local soundEvents = {
  OnExtend = "SND_TRAP_Spear_Spikes_Extend",
  OnRetract = "SND_TRAP_Spear_Spikes_Retract"
}
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDSpikeTrap")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
      LD.SoundDebug(tostring(key) .. ": " .. tostring(soundEvents[key]))
    end
  end
end
function PlaySoundSpikesExtend()
  LD.PlaySound(soundEmitter, soundEvents.OnExtend)
end
function PlaySoundSpikesRetract()
  LD.PlaySound(soundEmitter, soundEvents.OnRetract)
end
