local LD = require("design.LevelDesignLibrary")
local timers = require("level.timer")
local thisObj
local bFireOn = false
local bEnabled = true
local bBroken = false
local windupTimer
local durationWindup = 0
local windupVFX, initialDelayTimer, beam, onTimer, offTimer, beamCollisionTweakName, durationOn, durationOff
local markedForDisable = false
local lastFireState, controller
function OnScriptLoaded(level, obj)
  thisObj = obj
  bFireOn = false
  bEnabled = thisObj:GetLuaTableAttribute("startEnabled")
  beamCollisionTweakName = thisObj:GetLuaTableAttribute("TweaksCollision")
  durationOn = thisObj:GetLuaTableAttribute("durationOn")
  durationOff = thisObj:GetLuaTableAttribute("durationOff")
  durationWindup = thisObj:GetLuaTableAttribute("durationWindup")
  windupVFX = thisObj:GetLuaTableAttribute("windupVFXObj")
  if windupVFX then
    windupVFX = thisObj.Parent.Parent:FindSingleGOByName(windupVFX)
    windupVFX:Hide()
  end
  game.SubObject.Sleep(thisObj)
  game.SubObject.SetForgetOnCheckpoint(thisObj)
  thisObj:SetInhibitSave()
  SoundInit()
end
function OnStart()
  if not controller then
    if bEnabled then
      Enable()
    else
      Disable()
    end
  end
end
function OnSaveCheckpoint(level, obj)
  return {bBroken = bBroken}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  bBroken = savedInfo.bBroken
end
function SetController(newController, shouldEnable)
  controller = newController
  if shouldEnable ~= nil then
    if shouldEnable then
      Enable()
    else
      Disable()
    end
  end
end
function Break()
  Disable()
  bBroken = true
end
function Enable(initialDelay)
  if bBroken then
    return
  end
  bEnabled = true
  if initialDelay then
    initialDelayTimer = timers.StartLevelTimer(initialDelay, HiddenEnable)
  else
    HiddenEnable()
  end
end
function HiddenEnable()
  if beam == nil and (windupTimer == nil or windupTimer.running == false) then
    TurnOn()
  end
  bFireOn = true
end
function Disable()
  bEnabled = false
  TurnOff()
  if initialDelayTimer then
    initialDelayTimer:Stop()
    initialDelayTimer = nil
  end
  if onTimer then
    onTimer:Stop()
  end
  if offTimer then
    offTimer:Stop()
  end
  if windupTimer then
    windupTimer:Stop()
  end
end
function SoftDisable()
  if bEnabled == true then
    if 0 < durationOn then
      markedForDisable = true
      bFireOn = false
    else
      Disable()
    end
  end
end
function TurnOn()
  if not bEnabled or bFireOn then
    return
  end
  if not markedForDisable then
    bFireOn = true
  else
    markedForDisable = false
  end
  if windupVFX and 0 < durationWindup then
    windupVFX:Show()
    PlaySoundOnWindUp()
    if windupTimer then
      windupTimer:Restart()
    else
      windupTimer = timers.StartLevelTimer(durationWindup, StartBeam)
    end
  else
    StartBeam()
  end
end
function StartBeam()
  beam = game.Combat.CreateBeam(thisObj, beamCollisionTweakName)
  if 0 < durationOn then
    if onTimer then
      onTimer:Restart()
    else
      onTimer = timers.StartLevelTimer(durationOn, TurnOff)
    end
  end
  if windupVFX then
    windupVFX:Hide()
  end
end
function TurnOff()
  if windupVFX then
    windupVFX:Hide()
  end
  if windupTimer then
    windupTimer:Stop()
  end
  if beam then
    beam = nil
  end
  if bEnabled and 0 < durationOff and bFireOn then
    if offTimer then
      offTimer:Restart()
    else
      offTimer = timers.StartLevelTimer(durationOff, TurnOn)
    end
  end
  bFireOn = false
end
local soundEmitter
local soundEvents = {
  OnWindUp = "SND_TRAP_Fire_Trap_Charge"
}
function SoundInit()
  soundEmitter = thisObj:FindSingleSoundEmitterByName("SNDSprayerNozzle")
end
function SoundSetup(sounds)
  if sounds ~= nil then
    if sounds.SoundEmitter ~= nil then
      soundEmitter = thisObj:FindSingleSoundEmitterByName(sounds.SoundEmitter)
    end
    for key in pairs(soundEvents) do
      for newKey, newValue in pairs(sounds) do
        if newKey == key and newValue ~= nil and newValue ~= "" then
          soundEvents[key] = newValue
        end
      end
    end
  end
end
function PlaySoundOnWindUp()
  LD.PlaySound(soundEmitter, soundEvents.OnWindUp)
end
