local LD = require("design.LevelDesignLibrary")
local DL = require("design.DesignerLibrary")
local uiCalls = require("ui.uicalls")
local timers = require("level.timer")
local TUT = require("game.GlobalTutorials")
local thisObj, thisLevel, player, tutorialDone, interactZone, heroPuppeteer, interactionOnStart, interactionOnFinish, eventOnHandAttach, eventOnItemExtract, eventOnFirstChop, eventOnSecondChop, eventOnGearGive, chopType
typeIsDragonTooth = nil
typeIsChisel = nil
local enabled, interactionComplete, chiselFake, dragonToothAttach, chiselShardAttach
function OnScriptLoaded(level, obj)
  thisObj = obj
  thisLevel = level
  player = game.Player.FindPlayer()
  interactZone = game.InteractZone.New(obj, "promptJoint")
  interactZone:SetPromptJoint("promptJoint")
  interactZone:SetHintAngle(180)
  interactZone:SetYRange(2)
  interactZone:SetXZRange(3.5)
  interactZone:SetHintXZRange(10)
  interactZone:SetAngle(180)
  interactZone:SetTags("NotInRageMode")
  enabled = obj:GetLuaTableAttribute("startEnabled")
  interactionOnStart = obj:FindLuaTableAttribute("interactionOnStart")
  interactionOnFinish = obj:FindLuaTableAttribute("interactionOnFinish")
  eventOnHandAttach = obj:FindLuaTableAttribute("interactionOnHandAttach")
  eventOnItemExtract = obj:FindLuaTableAttribute("eventOnItemExtract")
  eventOnFirstChop = obj:FindLuaTableAttribute("eventOnFirstChop")
  eventOnSecondChop = obj:FindLuaTableAttribute("eventOnSecondChop")
  eventOnGearGive = obj:FindLuaTableAttribute("eventOnGearGive")
  if interactionOnStart ~= nil then
    interactionOnStart = LD.ExtractCallbacksForEvent(level, obj, interactionOnStart)
  end
  if interactionOnFinish ~= nil then
    interactionOnFinish = LD.ExtractCallbacksForEvent(level, obj, interactionOnFinish)
  end
  if eventOnHandAttach ~= nil then
    eventOnHandAttach = LD.ExtractCallbacksForEvent(level, obj, eventOnHandAttach)
  end
  if eventOnItemExtract ~= nil then
    eventOnItemExtract = LD.ExtractCallbacksForEvent(level, obj, eventOnItemExtract)
  end
  if eventOnFirstChop ~= nil then
    eventOnFirstChop = LD.ExtractCallbacksForEvent(level, obj, eventOnFirstChop)
  end
  if eventOnSecondChop ~= nil then
    eventOnSecondChop = LD.ExtractCallbacksForEvent(level, obj, eventOnSecondChop)
  end
  if eventOnGearGive ~= nil then
    eventOnGearGive = LD.ExtractCallbacksForEvent(level, obj, eventOnGearGive)
  end
  chopType = obj:FindLuaTableAttribute("ChopType")
  if chopType == "Chisel" then
    typeIsChisel = true
    typeIsDragonTooth = false
    chiselFake = obj:FindSingleGOByName("ChiselFake")
    chiselShardAttach = obj:FindSingleGOByName("chiselShard00")
    if chiselShardAttach ~= nil then
      chiselShardAttach:RegisterAsProp("chiselProxy")
      chiselShardAttach:Hide()
    end
  elseif chopType == "DragonTooth" then
    interactZone:SetAngle(120)
    typeIsChisel = false
    typeIsDragonTooth = true
    dragonToothAttach = obj:FindSingleGOByName("dragonToothTip00")
    if dragonToothAttach ~= nil then
      dragonToothAttach:RegisterAsProp("dragonTooth")
      dragonToothAttach:Hide()
    end
    chiselFake = nil
  end
end
function OnFirstStart(level, obj)
end
function OnStart(level, obj)
  if interactionComplete then
    Disable()
    if typeIsChisel then
      ChiselProxyVisible(false)
    end
  else
    RunInitCheck()
  end
end
function OnUseWorld(level, obj)
  if interactZone:PlayerCanInteract() then
    player:RequestInteract(thisObj)
  end
end
function RunInitCheck()
  if enabled then
    Enable()
    if typeIsChisel then
      ChiselProxyVisible(true)
    end
  else
    Disable()
  end
end
function Enable()
  interactZone:Enable()
  enabled = true
  if typeIsChisel then
    ChiselProxyVisible(true)
  end
end
function Disable()
  interactZone:Disable()
  local interactObj = player:GetCurrentInteractObject()
  if interactObj ~= thisObj then
    if typeIsChisel then
      ChiselProxyVisible(false)
    end
    enabled = false
  end
end
function InteractEnable()
  interactZone:Enable()
end
function OnInteractStart(level, obj, creature)
  PerformInteraction()
  if interactionOnStart ~= nil then
    print("INTERACTION ON STAAAAAAAAAAART", interactionOnStart)
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactionOnStart, "Interaction Event Start")
  end
end
function OnInteractAbort(level, obj, creature)
  print("GOT INTERACT ABORT")
  local renableTimer = StartLevelTimer(0.5, InteractEnable)
end
function OnInteractFinish(level, obj, creature)
  if interactionOnFinish ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, interactionOnFinish, "Interaction Event Finish")
  end
end
function OnInteractDone(level, obj, creature)
end
function PerformInteraction()
  if typeIsChisel then
    LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJoint", "Chisel Chop Enter", "BRA_ChiselChopEnter", "", interactZone, true, "Axe")
  else
    LD.PlaySingleSynchMove_KratosObject(thisObj, "synchJoint", "Dragon Chop Enter", "BRA_DragonChopEnter", "", interactZone, true, "Axe")
  end
end
function ClearTutorialMessage()
  uiCalls.UI_Event_ClearAllDesignerMessages()
end
function ChiselProxyVisible(value)
  if value == true then
    chiselFake:Show()
  else
    chiselFake:Hide()
  end
end
function LuaHook_ShowAxeTutorial()
  if not tutorialDone then
    tutorialDone = true
    TUT.AxeSwingTutorial()
  end
end
function LuaHook_AxeImpact01()
  ClearTutorialMessage()
  uiCalls.UI_Event_ClearAllDesignerMessages()
  if typeIsDragonTooth then
    local fx = game.FX.Spawn("BloodSplatFX", thisLevel, {AutoDelete = true})
    fx:SetWorldPosition(DL.GetWorldJointPositionByName(thisObj, "FXPosition01"))
  end
  if eventOnFirstChop ~= nil then
    print("INTERACTION ON FIRST CHOP VALID?", eventOnFirstChop)
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, eventOnFirstChop, "First Chop")
  end
end
function LuaHook_AxeImpact02()
  if typeIsDragonTooth then
    local fx = game.FX.Spawn("BloodSplatFX", thisLevel, {AutoDelete = true})
    fx:SetWorldPosition(DL.GetWorldJointPositionByName(thisObj, "FXPosition02"))
  end
  if eventOnSecondChop ~= nil then
    print("INTERACTION ON FIRST CHOP VALID?", eventOnFirstChop)
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, eventOnSecondChop, "second Chop")
  end
end
function LuaHook_ShowProp()
  if typeIsDragonTooth then
    dragonToothAttach:Show()
    local peak550 = game.FindLevel("Peak550_DragonArena")
    if peak550 ~= nil then
      peak550:CallScript("HideDragonTooth")
    end
  elseif typeIsChisel then
    chiselShardAttach:Show()
    ChiselProxyVisible(false)
  end
end
function LuaHook_HandAttach()
  if typeIsDragonTooth then
    local fx = game.FX.Spawn("tooth_pulp", thisLevel, {AutoDelete = true})
    fx:SetWorldPosition(DL.GetWorldJointPositionByName(thisObj, "FXPosition03"))
  end
  if eventOnHandAttach ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, eventOnHandAttach, "hand attach")
  end
end
function LuaHook_GiveItem()
  if eventOnGearGive ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, eventOnGearGive, "gear give")
  end
  interactionComplete = true
  if typeIsChisel then
    LD.GiveChisel()
  elseif typeIsDragonTooth then
    LD.GiveDragonTooth()
  end
end
function LuaHook_ObjectSnapOff()
  if eventOnItemExtract ~= nil then
    LD.ExecuteCallbacksForEvent(thisLevel, thisObj, eventOnItemExtract, "object snap off ")
  end
end
function OnSaveCheckpoint(level, obj)
  return {enabled = enabled, interactionComplete = interactionComplete}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  enabled = savedInfo.enabled
  interactionComplete = savedInfo.interactionComplete
end
