local LD = require("design.LevelDesignLibrary")
require("level.timer")
local thisLevel, thisObj
local isPlaying = false
local crystalDestroyed = false
local onHitCallbacks, breakableObj, breakableComponent, aimAssist, rumbleParams, shakeParams, controllerVibration, screenShake, animMesh, enabled
local buildUpTime = 1
function OnScriptLoaded(level, obj)
  obj:AddMarker("VibrateCrystalObj")
  obj:AddMarker("SonTarget")
  thisLevel = level
  thisObj = obj
  controllerVibration = obj:GetLuaTableAttribute("ControllerRumble")
  screenShake = obj:GetLuaTableAttribute("ScreenShake")
  onHitCallbacks = LD.ExtractCallbacksForEvent(level, obj, obj:FindLuaTableAttribute("OnProjectileHit"))
  aimAssist = obj:GetLuaTableAttribute("AimAssist")
  animMesh = thisObj.Parent:FindSingleGOByName("AnimMesh")
  animMesh:PauseAnim()
  breakableObj = thisObj
  breakableComponent = breakableObj:GetBreakable()
  rumbleParams = {
    EffectName = "FFB_GROUNDSHAKE_BUILDUP_START",
    Duration = buildUpTime
  }
  shakeParams = {
    EffectName = "FSE_CRYSTAL_EXPLODE",
    Duration = buildUpTime
  }
  if aimAssist and enabled then
    EnableObject(true)
  end
  game.SubObject.Sleep(thisObj)
end
function OnHitByArrow(level, go, arrow_owner, arrow_go, arrow_tweak)
  print("Vibrate arrow info", level, go, arrow_owner, arrow_go)
  if arrow_go:GetName() == "electricshock_arrow_notrail" then
    print("got hit by Son arrow...", arrow_go)
    CrystalHitByProjectile(level, go)
  else
    print("Must be something else...", arrow_go)
  end
end
function OnBreakableBroken(level, obj)
  thisObj:JumpAnimToFrame(0)
  thisObj:PauseAnim()
  crystalDestroyed = true
  LD.ExecuteCallbacksForEvent(thisLevel, thisObj, onHitCallbacks, "CrystalHitByProjectile")
  if controllerVibration then
    game.FX.SubmitEffect(rumbleParams)
  end
  if screenShake then
    game.FX.SubmitEffect(shakeParams)
  end
  local concussionParams = {
    Tweak = "CNC_VibrateExplosion_StoneMason",
    WorldLocation = thisObj:GetWorldPosition(),
    GameObject = game.Player.FindPlayer(),
    EnemyId = game.Player.FindPlayer():GetID()
  }
  game.Combat.PlayConcussion(concussionParams)
  local spawnPos = thisObj:GetWorldPosition()
  local navMeshPoint = game.NavMesh.ClosestPoint(spawnPos)
  local spawnArgs = {
    SpawnObject = "golootgenerichealthrune",
    OffsetPosition = navMeshPoint,
    Level = game.Level.GetPermLevel()
  }
  obj:SpawnGameObject(spawnArgs)
end
function OnUseWorld()
end
function CrystalHitByProjectile()
  animMesh:PlayAnimOscillate()
  animMesh:SetAnimRate(5)
  print("GOT HIT BY PROJECTILE")
  local buildUpFx = game.FX.Spawn("vibrate_buildUp_Boss", thisLevel, {
    GameObject = thisObj,
    Joint = "aimAssistJ",
    Scale = 2,
    AutoDelete = true
  })
  print("spawning build up fx")
  thisObj:RemoveAimAssist({
    Joint = "aimAssistJ",
    Angle = 12,
    MaxRadius = 1.4
  })
  if breakableComponent.Broken == false then
    _G.StartLevelTimer(buildUpTime, function()
      CrystalExplode()
    end)
  end
end
function CrystalExplode()
  game.FX.SubmitEffect(rumbleParams)
  game.FX.SubmitEffect(shakeParams)
  animMesh:Hide()
  if breakableComponent.Broken == false then
    breakableComponent:ShowPhysics()
    breakableComponent:Break()
  end
end
function EnableObject(data)
  if data == false then
    enabled = false
    thisObj:HidePhysics()
    thisObj:RemoveAimAssist({
      Joint = "aimAssistJ",
      Angle = 12,
      MaxRadius = 1.4
    })
  elseif data == true then
    enabled = true
    thisObj:ShowPhysics()
    if aimAssist then
      thisObj:AddAimAssist({
        Joint = "aimAssistJ",
        Angle = 12,
        MaxRadius = 1.4,
        ZoomSnapScreenAngle = 12,
        ZoomSnapRadius = 1.4,
        MaxDistance = -1
      })
    end
  end
end
function GetCrystalAvailable()
  if enabled then
    return true
  else
    return false
  end
end
function OnSaveCheckpoint(level)
  return {temp_crystalDestroyed = crystalDestroyed}
end
function OnRestoreCheckpoint(level, obj, tab)
  crystalDestroyed = tab.temp_crystalDestroyed
end
