local LD = require("design.LevelDesignLibrary")
local thisObj, StartEnabled, UseGlobalVariable, IsEnabled, GlobalVariableName, TurnOffCallback
IsTemporalObject = true
function OnScriptLoaded(level, obj)
  thisObj = obj
  StartEnabled = thisObj:FindLuaTableAttribute("StartEnabled")
  UseGlobalVariable = thisObj:FindLuaTableAttribute("UseGlobalVariable")
  if UseGlobalVariable then
    GlobalVariableName = thisObj:FindLuaTableAttribute("GlobalVariableName")
    assert(GlobalVariableName, "If you declare that this temporal object is tracked by a global variable you must provide a global variable name.")
  end
end
function OnStart(level, obj)
  if UseGlobalVariable and game.Level.GetVariable(GlobalVariableName) then
    IsEnabled = true
  end
  if IsEnabled ~= nil then
    if IsEnabled then
      Enable()
    else
      Disable()
    end
  elseif UseGlobalVariable then
    if game.Level.GetVariable(GlobalVariableName) == true and StartEnabled then
      Enable()
    else
      Disable()
    end
  elseif StartEnabled then
    Enable()
  else
    Disable()
  end
end
function OnSaveCheckpoint(level, obj)
  if UseGlobalVariable and game.Level.GetVariable(GlobalVariableName) then
    IsEnabled = true
  end
  return {IsEnabled = IsEnabled}
end
function OnRestoreCheckpoint(level, obj, savedInfo)
  IsEnabled = savedInfo.IsEnabled
end
function Enable()
  IsEnabled = true
  thisObj:ShowCollision()
  thisObj:Show()
  thisObj:StartAnimation({Animation = "TO_Idle"})
  thisObj:JumpAnimationToFrame(0)
  thisObj:PlayAnimationCycle()
end
function Disable()
  IsEnabled = false
  if TurnOffCallback then
    TurnOffCallback()
  end
  thisObj:ClearAllAnimationCallbacks()
  thisObj:HideCollision()
  thisObj:Hide()
end
function TurnTemporalObjectOn()
  thisObj:Show()
  thisObj:PlayAnimationToEnd({Animation = "TO_On", Rate = 0.5})
  thisObj:OnAnimationDone(thisObj, "Enable", {Animation = "TO_On", Force = true})
end
function TurnTemporalObjectOff(turnOffCallback)
  thisObj:StartAnimation({Animation = "TO_Off"})
  thisObj:JumpAnimationToFrame(0)
  thisObj:PlayAnimationToEnd()
  thisObj:OnAnimationDone(thisObj, "Disable", {Force = true})
  TurnOffCallback = turnOffCallback
end
function FlickerOff(flickerOffCallback)
  TurnOffCallback = flickerOffCallback
  thisObj:OnAnimationDone(thisObj, "Disable", {Animation = "TO_Off", Force = true})
  thisObj:PlayAnimationToEnd({Animation = "TO_Off", Rate = 2})
end
